/*
 * Decompiled with CFR 0.152.
 */
package net.parker8283.bif;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bowinfinityfix")
public class BowInfinityFix {
    public static final String MODID = "bowinfinityfix";
    private static final Logger LOGGER = LogManager.getLogger((String)"BowInfinityFix");

    public BowInfinityFix() {
        NeoForge.EVENT_BUS.addListener(this::infinityFix);
        LOGGER.info("Fix Registered!");
    }

    private void infinityFix(LivingGetProjectileEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)livingEntity;
            livingEntity = event.getProjectileWeaponItemStack().getItem();
            if (livingEntity instanceof ProjectileWeaponItem) {
                ArrowItem ai;
                ItemStack defaultStack;
                Item item;
                int countToUse;
                ProjectileWeaponItem pwi = (ProjectileWeaponItem)livingEntity;
                if (event.getProjectileItemStack().isEmpty() && (countToUse = (item = (defaultStack = pwi.getDefaultCreativeAmmo(player, event.getProjectileWeaponItemStack())).getItem()) instanceof ArrowItem && (ai = (ArrowItem)item).isInfinite(defaultStack, event.getProjectileWeaponItemStack(), (LivingEntity)player) ? 0 : EnchantmentHelper.processAmmoUse((ServerLevel)level, (ItemStack)event.getProjectileWeaponItemStack(), (ItemStack)defaultStack, (int)1)) == 0) {
                    event.setProjectileItemStack(defaultStack);
                }
            }
        }
    }
}

