/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.constructordestructor.AbstractTieredDestructorBlockEntity;
import com.ultramega.cabletiers.common.constructordestructor.ConstructorDestructorPropertyTypes;
import com.ultramega.cabletiers.common.registry.Menus;
import com.ultramega.cabletiers.common.support.AbstractTieredFilterContainerMenu;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TieredDestructorContainerMenu
extends AbstractTieredFilterContainerMenu<AbstractTieredDestructorBlockEntity> {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"destructor.filter_help");
    private final Predicate<Player> stillValid;

    public TieredDestructorContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData, CableTiers tier) {
        super(Menus.INSTANCE.getTieredDestructors(tier), syncId, playerInventory.player, resourceContainerData, AbstractTieredDestructorBlockEntity.getUpgradeDestination(tier), tier.getPlayerInventoryY(), (Component)FILTER_HELP, tier);
        this.stillValid = p -> true;
    }

    TieredDestructorContainerMenu(int syncId, Player player, AbstractTieredDestructorBlockEntity blockEntity, ResourceContainer filterContainer, UpgradeContainer upgradeContainer, CableTiers tier) {
        super(Menus.INSTANCE.getTieredDestructors(tier), syncId, player, filterContainer, upgradeContainer, blockEntity, tier.getPlayerInventoryY(), (Component)FILTER_HELP, tier);
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FILTER_MODE, (Object)FilterMode.BLOCK));
        this.registerProperty((Property)new ClientProperty(ConstructorDestructorPropertyTypes.PICKUP_ITEMS, (Object)false));
    }

    @Override
    protected void registerServerProperties(AbstractTieredDestructorBlockEntity blockEntity) {
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((AbstractTieredDestructorBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((AbstractTieredDestructorBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.FILTER_MODE, blockEntity::getFilterMode, blockEntity::setFilterMode));
        this.registerProperty((Property)new ServerProperty(ConstructorDestructorPropertyTypes.PICKUP_ITEMS, blockEntity::isPickupItems, blockEntity::setPickupItems));
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

