/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen.loot;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.registry.Blocks;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class BlockDropProvider
extends BlockLootSubProvider {
    public BlockDropProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        for (CableTiers tier : CableTiers.values()) {
            Blocks.INSTANCE.getTieredImporters(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            Blocks.INSTANCE.getTieredExporters(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            Blocks.INSTANCE.getTieredDestructors(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            Blocks.INSTANCE.getTieredConstructors(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            Blocks.INSTANCE.getTieredDiskInterfaces(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            Blocks.INSTANCE.getTieredAutocrafters(tier).forEach((color, id, block) -> this.drop((Block)block.get()));
            this.drop((Block)Blocks.INSTANCE.getTieredInterfaces(tier).get());
        }
    }

    private void drop(Block block) {
        this.add(block, this.createSingleItemTable((ItemLike)block).apply((LootItemFunction.Builder)BlockDropProvider.copyName()));
    }

    private static CopyComponentsFunction.Builder copyName() {
        return CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME);
    }

    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (CableTiers tier : CableTiers.values()) {
            blocks.addAll(Blocks.INSTANCE.getTieredImporters(tier).values());
            blocks.addAll(Blocks.INSTANCE.getTieredExporters(tier).values());
            blocks.addAll(Blocks.INSTANCE.getTieredDestructors(tier).values());
            blocks.addAll(Blocks.INSTANCE.getTieredConstructors(tier).values());
            blocks.addAll(Blocks.INSTANCE.getTieredDiskInterfaces(tier).values());
            blocks.addAll(Blocks.INSTANCE.getTieredAutocrafters(tier).values());
            blocks.add((Block)Blocks.INSTANCE.getTieredInterfaces(tier).get());
        }
        return blocks;
    }
}

