/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.caelus.common;

import com.illusivesoulworks.caelus.api.CaelusApi;
import com.illusivesoulworks.caelus.common.registry.RegistryObject;
import com.illusivesoulworks.caelus.common.registry.RegistryProvider;
import com.illusivesoulworks.caelus.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.ItemStack;

public class CaelusApiImpl
extends CaelusApi {
    public static final CaelusApi INSTANCE = new CaelusApiImpl();
    public static final RegistryProvider<Attribute> ATTRIBUTES = RegistryProvider.get(Registries.ATTRIBUTE, "caelus");
    private static final RegistryObject<Attribute> FALL_FLYING = ATTRIBUTES.register("fall_flying", () -> new RangedAttribute("caelus.fallFlying", 0.1, 0.0, 1.0).setSyncable(true));
    private static final AttributeModifier ELYTRA_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"caelus", (String)"elytra"), 1.0, AttributeModifier.Operation.ADD_VALUE);

    public static void setup() {
    }

    @Override
    public String getModId() {
        return "caelus";
    }

    @Override
    public Holder<Attribute> getFallFlyingAttribute() {
        return FALL_FLYING.asHolder();
    }

    @Override
    public AttributeModifier getElytraModifier() {
        return ELYTRA_MODIFIER;
    }

    @Override
    public CaelusApi.TriState canFallFly(LivingEntity livingEntity) {
        Holder<Attribute> att = this.getFallFlyingAttribute();
        AttributeInstance attribute = livingEntity.getAttribute(att);
        if (attribute != null) {
            double val = attribute.getValue();
            if (val >= 1.0) {
                return CaelusApi.TriState.ALLOW;
            }
            if (val > 0.0) {
                return CaelusApi.TriState.DEFAULT;
            }
            return CaelusApi.TriState.DENY;
        }
        ItemStack stack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (Services.CAELUS.canFly(stack, livingEntity)) {
            return CaelusApi.TriState.ALLOW;
        }
        return CaelusApi.TriState.DEFAULT;
    }

    @Override
    public boolean canFallFly(LivingEntity livingEntity, boolean checkDefaults) {
        return checkDefaults ? this.canFallFly(livingEntity) != CaelusApi.TriState.DENY : this.canFallFly(livingEntity) == CaelusApi.TriState.ALLOW;
    }
}

