/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.ClientComputerActions;
import dan200.computercraft.client.gui.ClientComputerInput;
import dan200.computercraft.client.gui.ItemToast;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.client.network.ClientNetworking;
import dan200.computercraft.core.input.UserComputerInput;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComputerScreen<T extends AbstractComputerMenu>
extends AbstractContainerScreen<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComputerScreen.class);
    private static final Component OK = Component.translatable((String)"gui.ok");
    private static final Component NO_RESPONSE_TITLE = Component.translatable((String)"gui.computercraft.upload.no_response");
    private static final Component NO_RESPONSE_MSG = Component.translatable((String)"gui.computercraft.upload.no_response.msg", (Object[])new Object[]{Component.literal((String)"import").withStyle(ChatFormatting.DARK_GRAY)});
    protected @Nullable TerminalWidget terminal;
    protected Terminal terminalData;
    protected final ComputerFamily family;
    protected final UserComputerInput computerInput;
    protected final ClientComputerActions computerActions;
    protected final int sidebarYOffset;
    private long uploadNagDeadline = Long.MAX_VALUE;
    private final int uploadMaxSize;
    private final ItemStack displayStack;

    public AbstractComputerScreen(T container, Inventory player, Component title, int sidebarYOffset) {
        super(container, player, title);
        this.terminalData = ((AbstractComputerMenu)container).getTerminal();
        this.family = ((AbstractComputerMenu)container).getFamily();
        this.displayStack = ((AbstractComputerMenu)container).getDisplayStack();
        this.uploadMaxSize = ((AbstractComputerMenu)container).getUploadMaxSize();
        this.computerInput = new UserComputerInput(new ClientComputerInput(this.menu), ((AbstractComputerMenu)this.menu).getTerminal());
        this.computerActions = new ClientComputerActions(this.menu);
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract TerminalWidget createTerminal();

    protected final TerminalWidget getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Screen has not been initialised yet");
        }
        return this.terminal;
    }

    protected void init() {
        super.init();
        this.terminal = (TerminalWidget)this.addRenderableWidget((GuiEventListener)this.createTerminal());
        ComputerSidebar.addButtons(((AbstractComputerMenu)this.menu)::isOn, this.computerActions, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, this.leftPos, this.topPos + this.sidebarYOffset);
        this.setFocused((GuiEventListener)this.terminal);
    }

    public void containerTick() {
        super.containerTick();
        this.getTerminal().update();
        if (this.uploadNagDeadline != Long.MAX_VALUE && Util.getNanos() >= this.uploadNagDeadline) {
            new ItemToast(this.minecraft(), this.displayStack, NO_RESPONSE_TITLE, NO_RESPONSE_MSG, ItemToast.TRANSFER_NO_RESPONSE_TOKEN).showOrReplace(this.minecraft().getToasts());
            this.uploadNagDeadline = Long.MAX_VALUE;
        }
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 258 && this.getFocused() != null && this.getFocused() == this.terminal) {
            return this.getFocused().keyPressed(key, scancode, modifiers);
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.setDragging(false);
        Optional child = this.getChildAt(x, y);
        if (child.isPresent() && ((GuiEventListener)child.get()).mouseReleased(x, y, button)) {
            return true;
        }
        return super.mouseReleased(x, y, button);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean changed = super.mouseClicked(x, y, button);
        if (this.getFocused() instanceof DynamicImageButton) {
            this.setFocused((GuiEventListener)this.terminal);
        }
        return changed;
    }

    public boolean mouseDragged(double x, double y, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.getFocused().mouseDragged(x, y, button, deltaX, deltaY) || super.mouseDragged(x, y, button, deltaX, deltaY);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener != this.getFocused()) {
            super.setFocused(listener);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void onFilesDrop(List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (!((AbstractComputerMenu)this.menu).isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                try {
                    long fileSize = sbc.size();
                    if (fileSize > (long)this.uploadMaxSize || (size += fileSize) >= (long)this.uploadMaxSize) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)Component.translatable((String)"gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)Component.translatable((String)"gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                finally {
                    if (sbc == null) continue;
                    sbc.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (Component)Component.translatable((String)"gui.computercraft.upload.failed.generic", (Object[])new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (Component)Component.translatable((String)"gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (!toUpload.isEmpty()) {
            UploadFileMessage.send(this.menu, toUpload, ClientNetworking::sendToServer);
        }
    }

    public void uploadResult(UploadResult result, @Nullable Component message) {
        switch (result) {
            case QUEUED: {
                if (Config.uploadNagDelay <= 0) break;
                this.uploadNagDeadline = Util.getNanos() + TimeUnit.SECONDS.toNanos(Config.uploadNagDelay);
                break;
            }
            case CONSUMED: {
                this.uploadNagDeadline = Long.MAX_VALUE;
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, Nullability.assertNonNull(message));
            }
        }
    }

    private void alert(Component title, Component message) {
        OptionScreen.show(this.minecraft(), title, message, List.of(OptionScreen.newButton(OK, b -> this.minecraft().setScreen((Screen)this))), () -> this.minecraft().setScreen((Screen)this));
    }

    private Minecraft minecraft() {
        return Nullability.assertNonNull(this.minecraft);
    }
}

