/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.integration.jei;

import dan200.computercraft.shared.integration.UpgradeRecipeGenerator;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

class RecipeResolver
implements IRecipeManagerPlugin {
    private final UpgradeRecipeGenerator<RecipeHolder<CraftingRecipe>> resolver;
    private int nextId = 0;

    RecipeResolver(HolderLookup.Provider registries) {
        this.resolver = new UpgradeRecipeGenerator<RecipeHolder>(x -> new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("upgrade_" + this.nextId++)), (Recipe)x), registries);
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object value = focus.getTypedValue().getIngredient();
        if (!(value instanceof ItemStack)) {
            return List.of();
        }
        ItemStack stack = (ItemStack)value;
        return switch (focus.getRole()) {
            case RecipeIngredientRole.INPUT -> {
                if (stack.getItem() instanceof TurtleItem || stack.getItem() instanceof PocketComputerItem || this.resolver.isUpgrade(stack)) {
                    yield List.of(RecipeTypes.CRAFTING);
                }
                yield List.of();
            }
            case RecipeIngredientRole.OUTPUT -> {
                if (stack.getItem() instanceof TurtleItem || stack.getItem() instanceof PocketComputerItem) {
                    yield List.of(RecipeTypes.CRAFTING);
                }
                yield List.of();
            }
            default -> List.of();
        };
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ItemStack stack;
        block7: {
            block6: {
                Object object = focus.getTypedValue().getIngredient();
                if (!(object instanceof ItemStack)) break block6;
                stack = (ItemStack)object;
                if (recipeCategory.getRecipeType() == RecipeTypes.CRAFTING) break block7;
            }
            return List.of();
        }
        return switch (focus.getRole()) {
            case RecipeIngredientRole.INPUT -> RecipeResolver.cast(RecipeTypes.CRAFTING, this.resolver.findRecipesWithInput(stack));
            case RecipeIngredientRole.OUTPUT -> RecipeResolver.cast(RecipeTypes.CRAFTING, this.resolver.findRecipesWithOutput(stack));
            default -> List.of();
        };
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }

    private static <T, U> List<T> cast(RecipeType<U> ignoredType, List<U> from) {
        return from;
    }
}

