/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SpriteRenderer {
    public static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/atlas/gui.png");
    private final Matrix4f transform;
    private final MultiBufferSource buffers;
    private final int light;
    private final int z;
    private final int colour;

    public SpriteRenderer(Matrix4f transform, MultiBufferSource buffers, int z, int light, int colour) {
        this.transform = transform;
        this.buffers = buffers;
        this.z = z;
        this.light = light;
        this.colour = colour;
    }

    public void blit(TextureAtlasSprite sprite, int x0, int y0, int width, int height, int spriteX, int spriteY, int spriteWidth, int spriteHeight) {
        if (width == 0 || height == 0) {
            return;
        }
        int x1 = x0 + width;
        int y1 = y0 + height;
        float u0 = sprite.getU((float)spriteX / (float)spriteWidth);
        float u1 = sprite.getU((float)(spriteX + width) / (float)spriteWidth);
        float v0 = sprite.getV((float)spriteY / (float)spriteHeight);
        float v1 = sprite.getV((float)(spriteY + height) / (float)spriteHeight);
        VertexConsumer vertices = this.buffers.getBuffer(RenderType.text((ResourceLocation)sprite.atlasLocation()));
        vertices.addVertex(this.transform, (float)x0, (float)y1, (float)this.z).setColor(this.colour).setUv(u0, v1).setLight(this.light);
        vertices.addVertex(this.transform, (float)x1, (float)y1, (float)this.z).setColor(this.colour).setUv(u1, v1).setLight(this.light);
        vertices.addVertex(this.transform, (float)x1, (float)y0, (float)this.z).setColor(this.colour).setUv(u1, v0).setLight(this.light);
        vertices.addVertex(this.transform, (float)x0, (float)y0, (float)this.z).setColor(this.colour).setUv(u0, v0).setLight(this.light);
    }

    public void blitTiled(TextureAtlasSprite sprite, int x, int y, int width, int height, int tileX, int tileY, int tileWidth, int tileHeight, int spriteWidth, int spriteHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + tileWidth + "x" + tileHeight);
        }
        for (int xOffset = 0; xOffset < width; xOffset += tileWidth) {
            int sliceWidth = Math.min(tileWidth, width - xOffset);
            for (int yOffset = 0; yOffset < height; yOffset += tileHeight) {
                int sliceHeight = Math.min(tileHeight, height - yOffset);
                this.blit(sprite, x + xOffset, y + yOffset, sliceWidth, sliceHeight, tileX, tileY, spriteWidth, spriteHeight);
            }
        }
    }
}

