/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.input;

import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.input.ComputerInput;
import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;

public final class EventComputerInput
implements ComputerInput {
    private final QueueEvent receiver;

    public EventComputerInput(QueueEvent receiver) {
        this.receiver = receiver;
    }

    public EventComputerInput(Computer computer) {
        this(computer::queueEvent);
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        this.receiver.queueEvent("key", new Object[]{key, repeat});
    }

    @Override
    public void keyUp(int key) {
        this.receiver.queueEvent("key_up", new Object[]{key});
    }

    @Override
    public void charTyped(byte chr) {
        this.receiver.queueEvent("char", new Object[]{new byte[]{chr}});
    }

    @Override
    public void paste(ByteBuffer contents) {
        this.receiver.queueEvent("paste", new Object[]{contents});
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        this.receiver.queueEvent("mouse_click", new Object[]{button, x, y});
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        this.receiver.queueEvent("mouse_up", new Object[]{button, x, y});
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        this.receiver.queueEvent("mouse_drag", new Object[]{button, x, y});
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        this.receiver.queueEvent("mouse_scroll", new Object[]{direction, x, y});
    }

    @FunctionalInterface
    public static interface QueueEvent {
        public void queueEvent(String var1, @Nullable Object @Nullable [] var2);
    }
}

