/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.google.auto.service.AutoService;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaCapability;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredElementCapability;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.FakePlayerExt;
import dan200.computercraft.shared.platform.ForgeConfigFile;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jspecify.annotations.Nullable;

@AutoService(value={PlatformHelper.class})
public class PlatformHelperImpl
implements PlatformHelper {
    @Override
    public boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new ForgeConfigFile.Builder();
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> registry) {
        return new RegistrationHelperImpl(DeferredRegister.create(registry, (String)"computercraft"));
    }

    @Override
    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> I registerArgumentTypeInfo(Class<A> klass, I info) {
        return (I)ArgumentTypeInfos.registerByClass(klass, info);
    }

    @Override
    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(StreamCodec<RegistryFriendlyByteBuf, T> codec, ContainerData.Factory<C, T> factory) {
        return IMenuTypeExtension.create((id, player, data) -> factory.create(id, player, (ContainerData)codec.decode((Object)data)));
    }

    @Override
    public void openMenu(Player player, Component title, MenuConstructor menu, ContainerData data) {
        player.openMenu((MenuProvider)new SimpleMenuProvider(menu, title), data::toBytes);
    }

    @Override
    public void invalidateComponent(BlockEntity owner) {
        owner.invalidateCapabilities();
    }

    @Override
    public ComponentAccess<IPeripheral> createPeripheralAccess(BlockEntity owner, Consumer<Direction> invalidate) {
        return new PeripheralAccess(owner, invalidate);
    }

    @Override
    public ComponentAccess<WiredElement> createWiredElementAccess(BlockEntity owner, Consumer<Direction> invalidate) {
        return new ComponentAccessImpl<WiredElement>(owner, WiredElementCapability.get(), invalidate);
    }

    @Override
    public boolean hasWiredElementIn(Level level, BlockPos pos, Direction direction) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        return level.getCapability(WiredElementCapability.get(), pos.relative(direction), (Object)direction.getOpposite()) != null;
    }

    @Override
    public ContainerTransfer.Slotted wrapContainer(Container container) {
        return new ForgeContainerTransfer((IItemHandler)new InvWrapper(container));
    }

    @Override
    public @Nullable ContainerTransfer getContainer(ServerLevel level, BlockPos pos, Direction side) {
        IItemHandler inventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
        if (inventory != null) {
            return new ForgeContainerTransfer(inventory);
        }
        Container entity = InventoryUtil.getEntityContainer(level, pos, side);
        return entity == null ? null : new ForgeContainerTransfer((IItemHandler)new InvWrapper(entity));
    }

    @Override
    public RecipeIngredients getRecipeIngredients() {
        return new RecipeIngredients(Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.GLASS_PANES), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.DYES), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.CHESTS_WOODEN));
    }

    @Override
    public List<TagKey<Item>> getDyeTags() {
        return List.of(Tags.Items.DYES_WHITE, Tags.Items.DYES_ORANGE, Tags.Items.DYES_MAGENTA, Tags.Items.DYES_LIGHT_BLUE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_LIME, Tags.Items.DYES_PINK, Tags.Items.DYES_GRAY, Tags.Items.DYES_LIGHT_GRAY, Tags.Items.DYES_CYAN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_BLUE, Tags.Items.DYES_BROWN, Tags.Items.DYES_GREEN, Tags.Items.DYES_RED, Tags.Items.DYES_BLACK);
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        return stack.getBurnTime(null);
    }

    @Override
    public CreativeModeTab.Builder newCreativeModeTab() {
        return CreativeModeTab.builder();
    }

    @Override
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    @Override
    public boolean onNotifyNeighbour(Level level, BlockPos pos, BlockState block, Direction direction) {
        return !EventHooks.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)block, EnumSet.of(direction), (boolean)false).isCanceled();
    }

    @Override
    public ServerPlayer createFakePlayer(ServerLevel world, GameProfile profile) {
        return new FakePlayerExt(world, profile);
    }

    @Override
    public boolean hasToolUsage(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.SHOVEL_FLATTEN) || stack.canPerformAction(ItemAbilities.HOE_TILL);
    }

    @Override
    public InteractionResult canAttackEntity(ServerPlayer player, Entity entity) {
        return CommonHooks.onPlayerAttackTarget((Player)player, (Entity)entity) ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    @Override
    public boolean interactWithEntity(ServerPlayer player, Entity entity, Vec3 hitPos) {
        InteractionResult interactAt = CommonHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)hitPos, (InteractionHand)InteractionHand.MAIN_HAND);
        if (interactAt == null) {
            interactAt = entity.interactAt((Player)player, hitPos.subtract(entity.position()), InteractionHand.MAIN_HAND);
        }
        return interactAt.consumesAction() || player.interactOn(entity, InteractionHand.MAIN_HAND).consumesAction();
    }

    @Override
    public PlatformHelper.UseOnResult useOn(ServerPlayer player, ItemStack stack, BlockHitResult hit) {
        InteractionResult result;
        BlockPos pos = hit.getBlockPos();
        PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return new PlatformHelper.UseOnResult.Handled(event.getCancellationResult());
        }
        UseOnContext context = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit);
        if (!event.getUseItem().isFalse() && (result = stack.onItemUseFirst(context)) != InteractionResult.PASS) {
            return new PlatformHelper.UseOnResult.Handled(event.getCancellationResult());
        }
        return new PlatformHelper.UseOnResult.Continue(!event.getUseBlock().isFalse(), !event.getUseItem().isFalse());
    }

    @Override
    public @Nullable IMedia getMedia(ItemStack stack) {
        return (IMedia)stack.getCapability(MediaCapability.get());
    }

    private record RegistrationHelperImpl<R>(DeferredRegister<R> registry) implements RegistrationHelper<R>
    {
        @Override
        public <T extends R> RegistryEntry<T> register(String name, Supplier<T> create) {
            return new RegistryEntryImpl(this.registry().register(name, create));
        }

        @Override
        public void register() {
            this.registry().register(ComputerCraft.getEventBus());
        }
    }

    private static class PeripheralAccess
    extends ComponentAccessImpl<IPeripheral> {
        PeripheralAccess(BlockEntity owner, Consumer<Direction> invalidate) {
            super(owner, PeripheralCapability.get(), invalidate);
        }

        @Override
        public @Nullable IPeripheral get(Direction direction) {
            IPeripheral result = (IPeripheral)super.get(direction);
            if (result != null) {
                return result;
            }
            BlockCapabilityCache cache = this.caches[direction.ordinal()];
            return Peripherals.getGenericPeripheral(cache.level(), cache.pos(), (Direction)cache.context(), cache.level().getBlockEntity(cache.pos()));
        }
    }

    private static class ComponentAccessImpl<T>
    implements ComponentAccess<T> {
        private final BlockEntity owner;
        private final BlockCapability<T, Direction> capability;
        private final Consumer<Direction> invalidate;
        final BlockCapabilityCache<T, Direction>[] caches = new BlockCapabilityCache[6];

        ComponentAccessImpl(BlockEntity owner, BlockCapability<T, Direction> capability, Consumer<Direction> invalidate) {
            this.owner = owner;
            this.capability = capability;
            this.invalidate = invalidate;
        }

        @Override
        public @Nullable T get(Direction direction) {
            ServerLevel level = this.getLevel();
            BlockCapabilityCache cache = this.caches[direction.ordinal()];
            if (cache == null) {
                BlockCapabilityCache blockCapabilityCache = BlockCapabilityCache.create(this.capability, (ServerLevel)level, (BlockPos)this.owner.getBlockPos().relative(direction), (Object)direction.getOpposite(), () -> !this.owner.isRemoved(), () -> this.invalidate.accept(direction));
                this.caches[direction.ordinal()] = blockCapabilityCache;
                cache = blockCapabilityCache;
            }
            return (T)cache.getCapability();
        }

        final ServerLevel getLevel() {
            return Objects.requireNonNull((ServerLevel)this.owner.getLevel(), "Block entity is not in a level");
        }
    }

    private record RegistryEntryImpl<R, T extends R>(DeferredHolder<R, T> object) implements RegistryEntry<T>
    {
        @Override
        public ResourceLocation id() {
            return this.object().getId();
        }

        @Override
        public T get() {
            return (T)this.object().get();
        }
    }
}

