/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.mixins;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @Inject(method={"getDrops(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/storage/loot/LootParams$Builder;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Ljava/util/Collections;emptyList()Ljava/util/List;", ordinal=0)}, cancellable=true)
    private void chipped$getDrops(BlockState state, LootParams.Builder builder, CallbackInfoReturnable<List<ItemStack>> cir) {
        Block block;
        ResourceLocation blockId;
        BlockBehaviourMixin blockBehaviourMixin = this;
        if (blockBehaviourMixin instanceof Block && (blockId = BuiltInRegistries.BLOCK.getKey((Object)(block = (Block)blockBehaviourMixin))).getNamespace().equals("chipped")) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("blocks/" + blockId.getPath()));
            LootTable table = builder.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id));
            if (table != LootTable.EMPTY) {
                LootParams context = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
                cir.setReturnValue((Object)table.getRandomItems(context));
            } else if (!state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) || state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                cir.setReturnValue(List.of(new ItemStack((ItemLike)block)));
            }
        }
    }
}

