/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel;

import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.block.ICarvable;
import com.leclowndu93150.chisel.block.BlockCarvableGlass;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.client.gui.AutoChiselScreen;
import com.leclowndu93150.chisel.client.gui.ChiselScreen;
import com.leclowndu93150.chisel.client.gui.HitechChiselScreen;
import com.leclowndu93150.chisel.client.particle.HolystoneStarParticle;
import com.leclowndu93150.chisel.compat.ChiselRebornCompat;
import com.leclowndu93150.chisel.compat.ftbultimine.FTBUltimineCompat;
import com.leclowndu93150.chisel.init.ChiselBlockEntities;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselCreativeTabs;
import com.leclowndu93150.chisel.init.ChiselDataComponents;
import com.leclowndu93150.chisel.init.ChiselItems;
import com.leclowndu93150.chisel.init.ChiselMenus;
import com.leclowndu93150.chisel.init.ChiselParticles;
import com.leclowndu93150.chisel.init.ChiselRegistries;
import com.leclowndu93150.chisel.init.ChiselSounds;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.slf4j.Logger;

@Mod(value="chisel")
public class Chisel {
    public static final String MODID = "chisel";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Chisel(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCapabilities);
        ChiselRebornCompat.registerAliases();
        ChiselRegistries.BLOCKS.register(modEventBus);
        ChiselRegistries.ITEMS.register(modEventBus);
        ChiselRegistries.CREATIVE_TABS.register(modEventBus);
        ChiselRegistries.BLOCK_ENTITY_TYPES.register(modEventBus);
        ChiselRegistries.MENU_TYPES.register(modEventBus);
        ChiselRegistries.SOUND_EVENTS.register(modEventBus);
        ChiselRegistries.DATA_COMPONENT_TYPES.register(modEventBus);
        ChiselRegistries.PARTICLE_TYPES.register(modEventBus);
        ChiselSounds.init();
        ChiselParticles.init();
        ChiselBlocks.init();
        ChiselItems.init();
        ChiselMenus.init();
        ChiselCreativeTabs.init();
        ChiselDataComponents.init();
        ChiselBlockEntities.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChiselConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ChiselMode.registerAll();
        if (ModList.get().isLoaded("ftbultimine")) {
            FTBUltimineCompat.init();
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ChiselBlockEntities.AUTO_CHISEL.get(), (blockEntity, side) -> {
            if (side == Direction.DOWN) {
                return blockEntity.getOutputInv();
            }
            if (side == Direction.UP) {
                return blockEntity.getInputInv();
            }
            if (side == null) {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{blockEntity.getInputInv(), blockEntity.getOutputInv(), blockEntity.getChiselSlot(), blockEntity.getTargetSlot()});
            }
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{blockEntity.getInputInv(), blockEntity.getOutputInv()});
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ChiselBlockEntities.AUTO_CHISEL.get(), (blockEntity, side) -> blockEntity.getEnergyStorage());
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="chisel", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ClientModEvents.registerBlockRenderType(ChiselBlocks.GLASS, RenderType.cutout());
                for (ChiselBlockType<BlockCarvableGlass> chiselBlockType : ChiselBlocks.GLASS_STAINED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.translucent());
                }
                for (ChiselBlockType<BlockCarvableGlass> chiselBlockType : ChiselBlocks.GLASS_DYED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.translucent());
                }
                for (ChiselBlockType<ICarvable> chiselBlockType : ChiselBlocks.GLASSPANE_DYED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.translucent());
                }
                ClientModEvents.registerBlockRenderType(ChiselBlocks.IRONPANE, RenderType.cutout());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.WATERSTONE, RenderType.cutout());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.LAVASTONE, RenderType.cutout());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.ANTIBLOCK, RenderType.cutout());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.CLOUD, RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChiselBlocks.AUTO_CHISEL.get()), (RenderType)RenderType.cutout());
            });
        }

        private static void registerBlockRenderType(ChiselBlockType<?> blockType, RenderType renderType) {
            for (DeferredBlock<?> deferredBlock : blockType.getAllBlocks()) {
                Block block = (Block)deferredBlock.get();
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
            }
        }

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ChiselMenus.CHISEL_MENU.get(), ChiselScreen::new);
            event.register((MenuType)ChiselMenus.HITECH_CHISEL_MENU.get(), HitechChiselScreen::new);
            event.register((MenuType)ChiselMenus.AUTO_CHISEL_MENU.get(), AutoChiselScreen::new);
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ChiselParticles.HOLYSTONE_STAR.get(), HolystoneStarParticle.Provider::new);
        }
    }
}

