/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.block;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.ChiselSound;
import com.leclowndu93150.chisel.api.block.VariationData;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.data.ChiselModelTemplates;
import com.leclowndu93150.chisel.init.ChiselRegistries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ChiselBlockType<T extends Block> {
    private final String name;
    private final List<VariationData> variations = new ArrayList<VariationData>();
    private final List<ResourceLocation> vanillaBlocks = new ArrayList<ResourceLocation>();
    private final List<TagKey<Block>> sourceBlockTags = new ArrayList<TagKey<Block>>();
    private final List<TagKey<Block>> blockTags = new ArrayList<TagKey<Block>>();
    private final List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
    @Nullable
    private Supplier<Block> propertiesFrom;
    @Nullable
    private BlockBehaviour.Properties customProperties;
    @Nullable
    private String groupName;
    @Nullable
    private TagKey<Block> carvingGroupTag;
    @Nullable
    private MapColor mapColor;
    @Nullable
    private Supplier<SoundType> soundTypeSupplier;
    @Nullable
    private ChiselSound chiselSound;
    @Nullable
    private ChiselModelTemplates.ModelTemplate defaultModelTemplate;
    private BiFunction<BlockBehaviour.Properties, VariationData, T> blockFactory;
    private final Map<String, DeferredBlock<T>> registeredBlocks = new LinkedHashMap<String, DeferredBlock<T>>();
    private final Map<String, DeferredItem<BlockItem>> registeredItems = new LinkedHashMap<String, DeferredItem<BlockItem>>();

    public ChiselBlockType(String name) {
        this.name = name;
        this.blockFactory = (props, data) -> new BlockCarvable((BlockBehaviour.Properties)props, (VariationData)data, name);
    }

    public ChiselBlockType(String name, BiFunction<BlockBehaviour.Properties, VariationData, T> factory) {
        this.name = name;
        this.blockFactory = factory;
    }

    public ChiselBlockType<T> addVanillaBlock(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (key != null) {
            this.vanillaBlocks.add(key);
        }
        return this;
    }

    public ChiselBlockType<T> addVanillaBlock(ResourceLocation blockId) {
        this.vanillaBlocks.add(blockId);
        return this;
    }

    public ChiselBlockType<T> addBlocksFromTag(TagKey<Block> tag) {
        this.sourceBlockTags.add(tag);
        return this;
    }

    public ChiselBlockType<T> properties(Supplier<Block> copyFrom) {
        this.propertiesFrom = copyFrom;
        return this;
    }

    public ChiselBlockType<T> properties(BlockBehaviour.Properties properties) {
        this.customProperties = properties;
        return this;
    }

    public ChiselBlockType<T> tag(TagKey<Block> tag) {
        this.blockTags.add(tag);
        return this;
    }

    public ChiselBlockType<T> itemTag(TagKey<Item> tag) {
        this.itemTags.add(tag);
        return this;
    }

    public ChiselBlockType<T> carvingGroup(TagKey<Block> tag) {
        this.carvingGroupTag = tag;
        return this;
    }

    public ChiselBlockType<T> groupName(String name) {
        this.groupName = name;
        return this;
    }

    public ChiselBlockType<T> mapColor(MapColor color) {
        this.mapColor = color;
        return this;
    }

    public ChiselBlockType<T> sound(Supplier<SoundType> soundTypeSupplier) {
        this.soundTypeSupplier = soundTypeSupplier;
        return this;
    }

    public ChiselBlockType<T> chiselSound(ChiselSound chiselSound) {
        this.chiselSound = chiselSound;
        return this;
    }

    public ChiselBlockType<T> variation(VariationData variation) {
        this.variations.add(variation);
        return this;
    }

    public ChiselBlockType<T> variation(String name) {
        this.variations.add(new VariationData(name));
        return this;
    }

    public ChiselBlockType<T> variation(String name, String localizedName) {
        this.variations.add(new VariationData(name, localizedName));
        return this;
    }

    public ChiselBlockType<T> variation(String name, String localizedName, ChiselModelTemplates.ModelTemplate modelTemplate) {
        this.variations.add(new VariationData(name, localizedName, modelTemplate, null));
        return this;
    }

    public ChiselBlockType<T> variations(List<VariationData> variations) {
        this.variations.addAll(variations);
        return this;
    }

    public ChiselBlockType<T> defaultModelTemplate(ChiselModelTemplates.ModelTemplate template) {
        this.defaultModelTemplate = template;
        return this;
    }

    @Nullable
    public ChiselModelTemplates.ModelTemplate getDefaultModelTemplate() {
        return this.defaultModelTemplate;
    }

    public ChiselBlockType<T> build() {
        for (VariationData variation : this.variations) {
            String registryName = this.name.replace("/", "_") + "/" + variation.name();
            BlockBehaviour.Properties props = this.customProperties != null ? this.customProperties : (this.propertiesFrom != null ? BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.propertiesFrom.get())) : BlockBehaviour.Properties.of());
            if (this.mapColor != null) {
                props = props.mapColor(this.mapColor);
            }
            if (this.soundTypeSupplier != null) {
                props = props.sound(this.soundTypeSupplier.get());
            }
            VariationData finalVariation = variation;
            BlockBehaviour.Properties finalProps = props;
            DeferredBlock block = ChiselRegistries.BLOCKS.register(registryName, () -> (Block)this.blockFactory.apply(finalProps, finalVariation));
            this.registeredBlocks.put(variation.name(), block);
            DeferredItem item = ChiselRegistries.ITEMS.registerSimpleBlockItem(registryName, (Supplier)block);
            this.registeredItems.put(variation.name(), (DeferredItem<BlockItem>)item);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName != null ? this.groupName : ChiselBlockType.toTitleCase(this.name) + " Block";
    }

    public List<VariationData> getVariations() {
        return Collections.unmodifiableList(this.variations);
    }

    public List<ResourceLocation> getVanillaBlocks() {
        return Collections.unmodifiableList(this.vanillaBlocks);
    }

    public List<TagKey<Block>> getSourceBlockTags() {
        return Collections.unmodifiableList(this.sourceBlockTags);
    }

    public List<TagKey<Block>> getBlockTags() {
        return Collections.unmodifiableList(this.blockTags);
    }

    public List<TagKey<Item>> getItemTags() {
        return Collections.unmodifiableList(this.itemTags);
    }

    public TagKey<Block> getCarvingGroupTag() {
        if (this.carvingGroupTag != null) {
            return this.carvingGroupTag;
        }
        return BlockTags.create((ResourceLocation)Chisel.id("carving/" + this.name.replace("/", "_")));
    }

    @Nullable
    public ChiselSound getChiselSound() {
        return this.chiselSound;
    }

    public Map<String, DeferredBlock<T>> getBlocks() {
        return Collections.unmodifiableMap(this.registeredBlocks);
    }

    public Map<String, DeferredItem<BlockItem>> getItems() {
        return Collections.unmodifiableMap(this.registeredItems);
    }

    @Nullable
    public DeferredBlock<T> getBlock(String variationName) {
        return this.registeredBlocks.get(variationName);
    }

    @Nullable
    public DeferredItem<BlockItem> getItem(String variationName) {
        return this.registeredItems.get(variationName);
    }

    public List<DeferredBlock<T>> getAllBlocks() {
        return new ArrayList<DeferredBlock<T>>(this.registeredBlocks.values());
    }

    public List<DeferredItem<BlockItem>> getAllItems() {
        return new ArrayList<DeferredItem<BlockItem>>(this.registeredItems.values());
    }

    private static String toTitleCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == '_' || c == ' ' || c == '/') {
                result.append(' ');
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

