/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data;

import com.leclowndu93150.chisel.api.block.VariationData;
import com.leclowndu93150.chisel.data.ChiselModelTemplates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.DyeColor;

public class VariantTemplates {
    public static final VariationData RAW = new VariationData("raw", "Raw", ChiselModelTemplates.simpleBlock());
    public static final List<VariationData> METAL = List.of(new VariationData("caution", "Caution", ChiselModelTemplates.simpleBlock()), new VariationData("crate", "Shipping Crate", ChiselModelTemplates.simpleBlock()), new VariationData("thermal", "Thermal", ChiselModelTemplates.cubeBottomTop()), new VariationData("machine", "Machine", ChiselModelTemplates.simpleBlock()).withTooltip("An Old Relic From The", "Land Of OneTeuFyv"), new VariationData("badgreggy", "Egregious", ChiselModelTemplates.simpleBlock()), new VariationData("bolted", "Bolted", ChiselModelTemplates.simpleBlock()), new VariationData("scaffold", "Scaffold", ChiselModelTemplates.simpleBlock()));
    public static final List<VariationData> METAL_TERRAIN = List.of(new VariationData("large_ingot", "Large Ingot", ChiselModelTemplates.cubeBottomTop()), new VariationData("small_ingot", "Small Ingot", ChiselModelTemplates.cubeBottomTop()), new VariationData("brick", "Brick", ChiselModelTemplates.cubeBottomTop()), new VariationData("coin_heads", "Coin (Heads)", ChiselModelTemplates.cubeBottomTop()), new VariationData("coin_tails", "Coin (Tails)", ChiselModelTemplates.cubeBottomTop()), new VariationData("crate_dark", "Dark Crate", ChiselModelTemplates.cubeBottomTop()), new VariationData("crate_light", "Light Crate", ChiselModelTemplates.cubeBottomTop()), new VariationData("plates", "Plates", ChiselModelTemplates.cubeBottomTop()), new VariationData("rivets", "Riveted Plates", ChiselModelTemplates.cubeBottomTop()), new VariationData("space", "Purple Space", ChiselModelTemplates.simpleBlock()), new VariationData("space_black", "Black Space", ChiselModelTemplates.simpleBlock()), new VariationData("simple", "Simple", ChiselModelTemplates.cubeBottomTop()));
    public static final List<VariationData> STONE = List.of(new VariationData("cracked", "Cracked", ChiselModelTemplates.simpleBlock()), new VariationData("solid_bricks", "Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("small_bricks", "Small Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("soft_bricks", "Weathered Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("cracked_bricks", "Cracked Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("triple_bricks", "Wide Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("encased_bricks", "Encased Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("array", "Arrayed Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_medium", "Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_large", "Big Tile", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_small", "Small Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("chaotic_medium", "Disordered Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("chaotic_small", "Small Disordered Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("braid", "Braid", ChiselModelTemplates.simpleBlock()), new VariationData("dent", "Dent", ChiselModelTemplates.simpleBlock()), new VariationData("french_1", "French 1", ChiselModelTemplates.simpleBlock()), new VariationData("french_2", "French 2", ChiselModelTemplates.simpleBlock()), new VariationData("jellybean", "Jellybean", ChiselModelTemplates.simpleBlock()), new VariationData("layers", "Layers", ChiselModelTemplates.simpleBlock()), new VariationData("mosaic", "Mosaic", ChiselModelTemplates.simpleBlock()), new VariationData("ornate", "Ornate", ChiselModelTemplates.simpleBlock()), new VariationData("panel", "Panel", ChiselModelTemplates.simpleBlock()), new VariationData("road", "Road", ChiselModelTemplates.simpleBlock()), new VariationData("slanted", "Slanted", ChiselModelTemplates.simpleBlock()), new VariationData("circular", "Circular", ChiselModelTemplates.simpleBlock()), new VariationData("pillar", "Pillar", ChiselModelTemplates.cubeColumn()), new VariationData("twisted", "Twisted", ChiselModelTemplates.cubeColumn()), new VariationData("prism", "Prism", ChiselModelTemplates.simpleBlock()));
    public static final List<VariationData> ROCK = List.of(new VariationData("cracked", "Cracked", ChiselModelTemplates.simpleBlock()), new VariationData("solid_bricks", "Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("small_bricks", "Small Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("soft_bricks", "Weathered Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("cracked_bricks", "Cracked Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("triple_bricks", "Wide Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("encased_bricks", "Encased Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("chaotic_bricks", "Trodden Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("array", "Arrayed Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_medium", "Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_large", "Big Tile", ChiselModelTemplates.simpleBlock()), new VariationData("tiles_small", "Small Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("chaotic_medium", "Disordered Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("chaotic_small", "Small Disordered Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("braid", "Braid", ChiselModelTemplates.simpleBlock()), new VariationData("dent", "Dent", ChiselModelTemplates.simpleBlock()), new VariationData("french_1", "French 1", ChiselModelTemplates.simpleBlock()), new VariationData("french_2", "French 2", ChiselModelTemplates.simpleBlock()), new VariationData("jellybean", "Jellybean", ChiselModelTemplates.simpleBlock()), new VariationData("layers", "Layers", ChiselModelTemplates.simpleBlock()), new VariationData("mosaic", "Mosaic", ChiselModelTemplates.simpleBlock()), new VariationData("ornate", "Ornate", ChiselModelTemplates.simpleBlock()), new VariationData("panel", "Panel", ChiselModelTemplates.simpleBlock()), new VariationData("road", "Road", ChiselModelTemplates.simpleBlock()), new VariationData("slanted", "Slanted", ChiselModelTemplates.simpleBlock()), new VariationData("zag", "Zag", ChiselModelTemplates.simpleBlock()), new VariationData("circular", "Circular", ChiselModelTemplates.simpleBlock()), new VariationData("circularct", "Circular", ChiselModelTemplates.ctm("circular")).withTooltip("Has CTM"), new VariationData("weaver", "Celtic", ChiselModelTemplates.simpleBlock()), new VariationData("pillar", "Pillar", ChiselModelTemplates.cubeColumn()), new VariationData("twisted", "Twisted", ChiselModelTemplates.cubeColumn()), new VariationData("prism", "Prism", ChiselModelTemplates.simpleBlock()), new VariationData("cuts", "Cuts", ChiselModelTemplates.simpleBlock()));
    public static final List<VariationData> COBBLESTONE;
    public static final List<VariationData> COBBLESTONE_MOSSY;
    public static final List<VariationData> PILLAR;
    public static final List<VariationData> PLANKS;
    public static final List<VariationData> COLORS;
    public static final List<VariationData> WOOL_CARPET;
    public static final List<VariationData> BOOKSHELF;
    public static final List<VariationData> SCRIBBLES;
    public static final List<VariationData> ANTIBLOCK;
    public static final List<VariationData> HEX_PLATING;
    public static final List<VariationData> LAVASTONE;
    public static final List<VariationData> WATERSTONE;
    public static final List<VariationData> FANTASY;
    public static final List<VariationData> WARNING;
    public static final List<VariationData> HOLYSTONE;
    public static final List<VariationData> FUTURA;

    private static ChiselModelTemplates.ModelTemplate mossyModel(String base, VariationData variant) {
        if (variant.name().equals("circularct")) {
            return ChiselModelTemplates.mossyCtm(base, "circular");
        }
        if (variant.name().equals("pillar") || variant.name().equals("twisted")) {
            return ChiselModelTemplates.mossyColumn(base);
        }
        return ChiselModelTemplates.mossy(base);
    }

    public static List<VariationData> colors(ChiselModelTemplates.ModelTemplate template) {
        return COLORS.stream().map(v -> v.withModelTemplate(template)).collect(Collectors.toUnmodifiableList());
    }

    public static List<VariationData> bookshelfForWood(String woodType) {
        return List.of(new VariationData("rainbow", "Rainbow", ChiselModelTemplates.bookshelf(woodType)), new VariationData("novice_necromancer", "Novice Necromancer", ChiselModelTemplates.bookshelf(woodType)), new VariationData("necromancer", "Necromancer", ChiselModelTemplates.bookshelf(woodType)), new VariationData("redtomes", "Red Tomes", ChiselModelTemplates.bookshelf(woodType)), new VariationData("abandoned", "Abandoned", ChiselModelTemplates.bookshelf(woodType)), new VariationData("hoarder", "Hoarder", ChiselModelTemplates.bookshelf(woodType)), new VariationData("brim", "Brim", ChiselModelTemplates.bookshelf(woodType)), new VariationData("historian", "Historian", ChiselModelTemplates.bookshelf(woodType)), new VariationData("cans", "Cans", ChiselModelTemplates.bookshelf(woodType)), new VariationData("papers", "Stacks Of Papers", ChiselModelTemplates.bookshelf(woodType)));
    }

    private static String toTitleCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == '_' || c == ' ') {
                result.append(' ');
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static {
        ArrayList<VariationData> cobble = new ArrayList<VariationData>(ROCK);
        cobble.add(new VariationData("extra/emboss", "Embossed", ChiselModelTemplates.simpleBlock()));
        cobble.add(new VariationData("extra/indent", "Indent", ChiselModelTemplates.simpleBlock()));
        cobble.add(new VariationData("extra/marker", "Marker", ChiselModelTemplates.simpleBlock()));
        COBBLESTONE = List.copyOf(cobble);
        ArrayList<VariationData> mossy = new ArrayList<VariationData>();
        for (VariationData v : COBBLESTONE) {
            mossy.add(new VariationData(v.name(), v.localizedName(), VariantTemplates.mossyModel("cobblestone", v), v.tooltip(), v.textureOverride()));
        }
        COBBLESTONE_MOSSY = List.copyOf(mossy);
        PILLAR = List.of(new VariationData("plainplain", "Plain-Capped Plain Pillar", ChiselModelTemplates.columnPillar()), new VariationData("plaingreek", "Greek-Capped Plain Pillar", ChiselModelTemplates.columnPillar()), new VariationData("greekplain", "Plain-Capped Greek Pillar", ChiselModelTemplates.columnPillar()), new VariationData("greekgreek", "Greek-Capped Greek Pillar", ChiselModelTemplates.columnPillar()), new VariationData("convex_plain", "Convexed Pillar", ChiselModelTemplates.cubeAll("-top")), new VariationData("carved", "Scribed Pillar", ChiselModelTemplates.cubeColumn()), new VariationData("ornamental", "Ornamental Pillar", ChiselModelTemplates.cubeColumn()));
        PLANKS = List.of(new VariationData("large_planks", "Large Planks", ChiselModelTemplates.simpleBlock()), new VariationData("crude_horizontal_planks", "Crude Horizontal Planks", ChiselModelTemplates.simpleBlock()), new VariationData("vertical_planks", "Vertical Planks", ChiselModelTemplates.simpleBlock()), new VariationData("crude_vertical_planks", "Crude Vertical Planks", ChiselModelTemplates.simpleBlock()), new VariationData("encased_planks", "Encased Planks", ChiselModelTemplates.simpleBlock()), new VariationData("encased_large_planks", "Encased Large Planks", ChiselModelTemplates.simpleBlock()), new VariationData("braced_planks", "Braced Planks", ChiselModelTemplates.cubeColumn("log_bordered", "log_bordered")), new VariationData("shipping_crate", "Shipping Crate", ChiselModelTemplates.simpleBlock()), new VariationData("paneling", "Paneling", ChiselModelTemplates.simpleBlock()), new VariationData("crude_paneling", "Crude Paneling", ChiselModelTemplates.simpleBlock()), new VariationData("stacked", "Stacked", ChiselModelTemplates.simpleBlock()), new VariationData("smooth", "Smooth", ChiselModelTemplates.simpleBlock()), new VariationData("encased_smooth", "Encased Smooth", ChiselModelTemplates.simpleBlock()), new VariationData("braid", "Braid", ChiselModelTemplates.simpleBlock()), new VariationData("log_cabin", "Log Cabin", ChiselModelTemplates.axisFacesNoTop()));
        COLORS = Arrays.stream(DyeColor.values()).map(color -> new VariationData(color.getSerializedName(), VariantTemplates.toTitleCase(color.getSerializedName()), ChiselModelTemplates.simpleBlock())).collect(Collectors.toUnmodifiableList());
        WOOL_CARPET = List.of(new VariationData("legacy", "Legacy", ChiselModelTemplates.simpleBlock()), new VariationData("llama", "Llama", ChiselModelTemplates.simpleBlock()));
        BOOKSHELF = List.of(new VariationData("rainbow", "Rainbow", ChiselModelTemplates.bookshelf()), new VariationData("novice_necromancer", "Novice Necromancer", ChiselModelTemplates.bookshelf()), new VariationData("necromancer", "Necromancer", ChiselModelTemplates.bookshelf()), new VariationData("redtomes", "Red Tomes", ChiselModelTemplates.bookshelf()), new VariationData("abandoned", "Abandoned", ChiselModelTemplates.bookshelf()), new VariationData("hoarder", "Hoarder", ChiselModelTemplates.bookshelf()), new VariationData("brim", "Brim", ChiselModelTemplates.bookshelf()), new VariationData("historian", "Historian", ChiselModelTemplates.bookshelf()), new VariationData("cans", "Cans", ChiselModelTemplates.bookshelf()), new VariationData("papers", "Stacks Of Papers", ChiselModelTemplates.bookshelf()));
        SCRIBBLES = List.of(new VariationData("scribbles_0", "Hieroglyphs 1", ChiselModelTemplates.cubeColumn("scribbles_0-side", "scribbles_0-top")), new VariationData("scribbles_1", "Hieroglyphs 2", ChiselModelTemplates.cubeColumn("scribbles_1-side", "scribbles_0-top")), new VariationData("scribbles_2", "Hieroglyphs 3", ChiselModelTemplates.cubeColumn("scribbles_2-side", "scribbles_0-top")), new VariationData("scribbles_3", "Skull 1", ChiselModelTemplates.cubeColumn("scribbles_3-side", "scribbles_0-top")), new VariationData("scribbles_4", "Eye of Horus", ChiselModelTemplates.cubeColumn("scribbles_4-side", "scribbles_0-top")), new VariationData("scribbles_5", "Bird", ChiselModelTemplates.cubeColumn("scribbles_5-side", "scribbles_0-top")), new VariationData("scribbles_6", "Halo", ChiselModelTemplates.cubeColumn("scribbles_6-side", "scribbles_0-top")), new VariationData("scribbles_7", "Hieroglyphs 4", ChiselModelTemplates.cubeColumn("scribbles_7-side", "scribbles_0-top")), new VariationData("scribbles_8", "Man with Staff", ChiselModelTemplates.cubeColumn("scribbles_8-side", "scribbles_0-top")), new VariationData("scribbles_9", "Waves", ChiselModelTemplates.cubeColumn("scribbles_9-side", "scribbles_0-top")), new VariationData("scribbles_10", "Landscape 1", ChiselModelTemplates.cubeColumn("scribbles_10-side", "scribbles_0-top")), new VariationData("scribbles_11", "Skull Landscape", ChiselModelTemplates.cubeColumn("scribbles_11-side", "scribbles_0-top")), new VariationData("scribbles_12", "Pattern 1", ChiselModelTemplates.cubeColumn("scribbles_12-side", "scribbles_0-top")), new VariationData("scribbles_13", "Pattern 2", ChiselModelTemplates.cubeColumn("scribbles_13-side", "scribbles_0-top")), new VariationData("scribbles_14", "Hieroglyphs 5", ChiselModelTemplates.cubeColumn("scribbles_14-side", "scribbles_0-top")), new VariationData("scribbles_15", "Hieroglyphs 6", ChiselModelTemplates.cubeColumn("scribbles_15-side", "scribbles_0-top")));
        ANTIBLOCK = List.of(new VariationData("white", "White", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("orange", "Orange", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("magenta", "Magenta", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("light_blue", "Light Blue", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("yellow", "Yellow", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("lime", "Lime", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("pink", "Pink", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("gray", "Gray", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("light_gray", "Light Gray", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("cyan", "Cyan", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("purple", "Purple", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("blue", "Blue", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("brown", "Brown", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("green", "Green", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("red", "Red", ChiselModelTemplates.twoLayerWithTop("antiblock", false)), new VariationData("black", "Black", ChiselModelTemplates.twoLayerWithTop("antiblock", false)));
        HEX_PLATING = List.of(new VariationData("hexbase", "Hex Base", ChiselModelTemplates.hexPlate("hexbase")), new VariationData("hexnew", "Hex New", ChiselModelTemplates.hexPlate("hexnew")));
        LAVASTONE = List.of(new VariationData("cracked", "Cracked", ChiselModelTemplates.fluidCube("lava")), new VariationData("soft_bricks", "Weathered Bricks", ChiselModelTemplates.fluidCube("lava")), new VariationData("triple_bricks", "Wide Bricks", ChiselModelTemplates.fluidCube("lava")), new VariationData("encased_bricks", "Encased Bricks", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("braid", "Braid", ChiselModelTemplates.fluidCube("lava")), new VariationData("array", "Arrayed Bricks", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("tiles_large", "Big Tile", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("tiles_small", "Small Tiles", ChiselModelTemplates.fluidCube("lava")), new VariationData("chaotic_medium", "Disordered Tiles", ChiselModelTemplates.fluidCube("lava")), new VariationData("chaotic_small", "Small Disordered Tiles", ChiselModelTemplates.fluidCube("lava")), new VariationData("dent", "Dent", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("french_1", "French 1", ChiselModelTemplates.fluidCube("lava")), new VariationData("french_2", "French 2", ChiselModelTemplates.fluidCube("lava")), new VariationData("jellybean", "Jellybean", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("layers", "Layers", ChiselModelTemplates.fluidCube("lava")), new VariationData("mosaic", "Mosaic", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("ornate", "Ornate", ChiselModelTemplates.fluidCube("lava")), new VariationData("panel", "Panel", ChiselModelTemplates.fluidCube("lava")), new VariationData("road", "Road", ChiselModelTemplates.fluidCube("lava")), new VariationData("slanted", "Slanted", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("zag", "Zag", ChiselModelTemplates.fluidCube("lava")), new VariationData("circularct", "Circular", ChiselModelTemplates.fluidCubeCTM("lava", "circular")), new VariationData("weaver", "Celtic", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("solid_bricks", "Bricks", ChiselModelTemplates.fluidCube("lava")), new VariationData("small_bricks", "Small Bricks", ChiselModelTemplates.fluidCube("lava")), new VariationData("circular", "Circular", ChiselModelTemplates.fluidCube("lava")), new VariationData("tiles_medium", "Tiles", ChiselModelTemplates.fluidCube("lava")), new VariationData("pillar", "Pillar", ChiselModelTemplates.fluidPassColumn("lava")), new VariationData("twisted", "Twisted", ChiselModelTemplates.fluidPassColumn("lava")), new VariationData("prism", "Prism", ChiselModelTemplates.fluidCube("lava")), new VariationData("chaotic_bricks", "Trodden Bricks", ChiselModelTemplates.fluidPassCube("lava")), new VariationData("cuts", "Cuts", ChiselModelTemplates.fluidPassCube("lava")));
        WATERSTONE = List.of(new VariationData("cracked", "Cracked", ChiselModelTemplates.fluidCube("water")), new VariationData("soft_bricks", "Weathered Bricks", ChiselModelTemplates.fluidCube("water")), new VariationData("triple_bricks", "Wide Bricks", ChiselModelTemplates.fluidCube("water")), new VariationData("encased_bricks", "Encased Bricks", ChiselModelTemplates.fluidPassCube("water")), new VariationData("braid", "Braid", ChiselModelTemplates.fluidCube("water")), new VariationData("array", "Arrayed Bricks", ChiselModelTemplates.fluidPassCube("water")), new VariationData("tiles_large", "Big Tile", ChiselModelTemplates.fluidPassCube("water")), new VariationData("tiles_small", "Small Tiles", ChiselModelTemplates.fluidCube("water")), new VariationData("chaotic_medium", "Disordered Tiles", ChiselModelTemplates.fluidCube("water")), new VariationData("chaotic_small", "Small Disordered Tiles", ChiselModelTemplates.fluidCube("water")), new VariationData("dent", "Dent", ChiselModelTemplates.fluidPassCube("water")), new VariationData("french_1", "French 1", ChiselModelTemplates.fluidCube("water")), new VariationData("french_2", "French 2", ChiselModelTemplates.fluidCube("water")), new VariationData("jellybean", "Jellybean", ChiselModelTemplates.fluidPassCube("water")), new VariationData("layers", "Layers", ChiselModelTemplates.fluidCube("water")), new VariationData("mosaic", "Mosaic", ChiselModelTemplates.fluidPassCube("water")), new VariationData("ornate", "Ornate", ChiselModelTemplates.fluidCube("water")), new VariationData("panel", "Panel", ChiselModelTemplates.fluidCube("water")), new VariationData("road", "Road", ChiselModelTemplates.fluidCube("water")), new VariationData("slanted", "Slanted", ChiselModelTemplates.fluidPassCube("water")), new VariationData("zag", "Zag", ChiselModelTemplates.fluidCube("water")), new VariationData("circularct", "Circular", ChiselModelTemplates.fluidCubeCTM("water", "circular")), new VariationData("weaver", "Celtic", ChiselModelTemplates.fluidPassCube("water")), new VariationData("solid_bricks", "Bricks", ChiselModelTemplates.fluidCube("water")), new VariationData("small_bricks", "Small Bricks", ChiselModelTemplates.fluidCube("water")), new VariationData("circular", "Circular", ChiselModelTemplates.fluidCube("water")), new VariationData("tiles_medium", "Tiles", ChiselModelTemplates.fluidCube("water")), new VariationData("pillar", "Pillar", ChiselModelTemplates.fluidPassColumn("water")), new VariationData("twisted", "Twisted", ChiselModelTemplates.fluidPassColumn("water")), new VariationData("prism", "Prism", ChiselModelTemplates.fluidCube("water")), new VariationData("chaotic_bricks", "Trodden Bricks", ChiselModelTemplates.fluidPassCube("water")), new VariationData("cuts", "Cuts", ChiselModelTemplates.fluidPassCube("water")));
        FANTASY = List.of(new VariationData("brick", "Brick", ChiselModelTemplates.cubeColumn("brick_side", "brick_top")), new VariationData("brick_faded", "Brick Faded", ChiselModelTemplates.cubeColumn("brick_faded_side", "brick_faded_top")), new VariationData("brick_wear", "Brick Wear", ChiselModelTemplates.cubeColumn("brick_wear_side", "brick_wear_top")), new VariationData("bricks", "Bricks", ChiselModelTemplates.cubeColumn("bricks_side", "bricks_top")), new VariationData("decor", "Decor", ChiselModelTemplates.cubeColumn("decor_side", "decor_top")), new VariationData("decor_block", "Decor Block", ChiselModelTemplates.cubeColumn("decor_block_side", "decor_block_top")), new VariationData("pillar", "Pillar", ChiselModelTemplates.cubeColumn("pillar_side", "pillar_top")), new VariationData("pillar_decorated", "Pillar Decorated", ChiselModelTemplates.cubeColumn("pillar_decorated_side", "pillar_decorated_top")), new VariationData("gold_decor_1", "Gold Decor 1", ChiselModelTemplates.cubeColumn("gold_decor_1_side", "gold_decor_1_top")), new VariationData("gold_decor_2", "Gold Decor 2", ChiselModelTemplates.cubeColumn("gold_decor_2_side", "gold_decor_2_top")), new VariationData("gold_decor_3", "Gold Decor 3", ChiselModelTemplates.cubeColumn("gold_decor_3_side", "gold_decor_3_top")), new VariationData("gold_decor_4", "Gold Decor 4", ChiselModelTemplates.cubeColumn("gold_decor_4_side", "gold_decor_4_top")), new VariationData("plate", "Plate", ChiselModelTemplates.cubeColumn("plate_side", "plate_top")), new VariationData("block", "Block", ChiselModelTemplates.simpleBlock()).withTooltip("Has CTM"), new VariationData("bricks_chaotic", "Bricks Chaotic", ChiselModelTemplates.simpleBlock()), new VariationData("bricks_wear", "Bricks Wear", ChiselModelTemplates.cubeColumn("bricks_wear_side", "bricks_wear_top")));
        WARNING = List.of(new VariationData("radiation", "Radiation", ChiselModelTemplates.simpleBlock()), new VariationData("biohazard", "Biohazard", ChiselModelTemplates.simpleBlock()), new VariationData("fire", "Fire", ChiselModelTemplates.simpleBlock()), new VariationData("explosion", "Explosion", ChiselModelTemplates.simpleBlock()), new VariationData("death", "Death", ChiselModelTemplates.simpleBlock()), new VariationData("falling", "Falling", ChiselModelTemplates.simpleBlock()), new VariationData("fall", "Fall", ChiselModelTemplates.simpleBlock()), new VariationData("voltage", "Voltage", ChiselModelTemplates.simpleBlock()), new VariationData("generic", "Generic", ChiselModelTemplates.simpleBlock()), new VariationData("acid", "Acid", ChiselModelTemplates.simpleBlock()), new VariationData("underconstruction", "Under Construction", ChiselModelTemplates.simpleBlock()), new VariationData("sound", "Sound", ChiselModelTemplates.simpleBlock()), new VariationData("noentry", "No Entry", ChiselModelTemplates.simpleBlock()), new VariationData("cryogenic", "Cryogenic", ChiselModelTemplates.simpleBlock()), new VariationData("oxygen", "Oxygen", ChiselModelTemplates.simpleBlock()));
        HOLYSTONE = List.of(new VariationData("raw", "Holystone", ChiselModelTemplates.simpleBlock()), new VariationData("smooth", "Smooth", ChiselModelTemplates.simpleBlock()), new VariationData("love", "Love", ChiselModelTemplates.simpleBlock()), new VariationData("chiseled", "Chiseled", ChiselModelTemplates.cubeColumn("chiseled_side", "chiseled_top")), new VariationData("blocks", "Blocks", ChiselModelTemplates.simpleBlock()), new VariationData("blocks_rough", "Blocks Rough", ChiselModelTemplates.simpleBlock()), new VariationData("brick", "Brick", ChiselModelTemplates.simpleBlock()), new VariationData("large_bricks", "Large Bricks", ChiselModelTemplates.simpleBlock()), new VariationData("platform", "Platform", ChiselModelTemplates.cubeBottomTop("platform_top", "platform_bottom", "platform_side")), new VariationData("platform_tiles", "Platform Tiles", ChiselModelTemplates.cubeBottomTop("platform_tiles_top", "platform_tiles_bottom", "platform_tiles_side")), new VariationData("construction", "Construction", ChiselModelTemplates.simpleBlock()), new VariationData("fancy_tiles", "Fancy Tiles", ChiselModelTemplates.simpleBlock()), new VariationData("plate", "Plate", ChiselModelTemplates.simpleBlock()), new VariationData("plate_rough", "Plate Rough", ChiselModelTemplates.simpleBlock()));
        FUTURA = List.of(new VariationData("screen_metallic", "Screen Metallic", ChiselModelTemplates.simpleBlock()), new VariationData("screen_cyan", "Screen Cyan", ChiselModelTemplates.simpleBlock()), new VariationData("controller", "Controller", ChiselModelTemplates.simpleBlock()), new VariationData("wavy", "Wavy", ChiselModelTemplates.simpleBlock()), new VariationData("controller_purple", "Controller Purple", ChiselModelTemplates.simpleBlock()), new VariationData("uber_wavy", "Uber Wavy", ChiselModelTemplates.simpleBlock()));
    }
}

