/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ChiselItemTagsProvider
extends ItemTagsProvider {
    public ChiselItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "chisel", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            TagKey carvingItemTag = ItemTags.create((ResourceLocation)Chisel.id("carving/" + blockType.getName().replace("/", "_")));
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tagBuilder = this.tag(carvingItemTag);
            for (DeferredItem<BlockItem> deferredItem : blockType.getAllItems()) {
                tagBuilder.add((Object)((Item)deferredItem.get()));
            }
            for (ResourceLocation resourceLocation : blockType.getVanillaBlocks()) {
                tagBuilder.addOptional(resourceLocation);
            }
            for (TagKey tagKey : blockType.getSourceBlockTags()) {
                TagKey sourceItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagKey.location());
                tagBuilder.addOptionalTag(sourceItemTag);
            }
            for (TagKey tagKey : blockType.getItemTags()) {
                IntrinsicHolderTagsProvider.IntrinsicTagAppender itemTagBuilder = this.tag(tagKey);
                for (DeferredItem<BlockItem> item : blockType.getAllItems()) {
                    itemTagBuilder.add((Object)((Item)item.get()));
                }
            }
        }
    }
}

