/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jagm.classicpipes.block.PipeBlock;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BooleanDirectionsPipeBlock
extends PipeBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN)));

    public BooleanDirectionsPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isPipeConnected(BlockState state, Direction direction) {
        return (Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
    }

    @Override
    public BlockState setPipeConnected(BlockState state, Direction direction, boolean connected) {
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(connected));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        if (superState != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)superState.trySetValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.NORTH)))).trySetValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.EAST)))).trySetValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.SOUTH)))).trySetValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.WEST)))).trySetValue((Property)UP, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.UP)))).trySetValue((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.DOWN)));
        }
        return this.defaultBlockState();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }
}

