/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.BooleanDirectionsPipeBlock;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BrickPipeBlock
extends BooleanDirectionsPipeBlock {
    public BrickPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RoundRobinPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.BASIC_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    protected boolean canConnect(Level level, BlockPos pipePos, Direction direction) {
        Block block = level.getBlockState(pipePos.relative(direction)).getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)block;
            return BrickPipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return false;
    }
}

