/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.api.heart.drawing;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;

public class Heart {
    private static final Set<Heart> CACHE = new HashSet<Heart>();
    public static final Heart CONTAINER_FULL = new Heart(Hearts.CONTAINER, false, null);
    public static final Heart CONTAINER_HALF = new Heart(Hearts.CONTAINER, true, null);
    public static final Heart CONTAINER_NONE = new Heart(null, false, null);
    private final HeartDrawing drawing;
    private final boolean half;
    private final Heart backgroundHeart;

    private Heart(HeartDrawing drawing, boolean half, Heart backgroundHeart) {
        this.drawing = drawing;
        this.half = half;
        this.backgroundHeart = backgroundHeart;
    }

    public static Heart full(@NotNull HeartDrawing drawing) {
        return CACHE.stream().filter(h -> !h.half && Objects.equals(h.drawing, drawing) && h.backgroundHeart == CONTAINER_FULL).findAny().orElseGet(() -> {
            Heart heart = new Heart(drawing, false, CONTAINER_FULL);
            CACHE.add(heart);
            return heart;
        });
    }

    public static Heart full(@NotNull HeartDrawing drawing, boolean half, @NotNull Heart background) {
        return CACHE.stream().filter(h -> h.half == half && Objects.equals(h.drawing, drawing) && h.backgroundHeart == background).findAny().orElseGet(() -> {
            Heart heart = new Heart(drawing, half, background);
            CACHE.add(heart);
            return heart;
        });
    }

    public static Heart full(@NotNull HeartDrawing drawing, @NotNull Heart background) {
        return Heart.full(drawing, true, background);
    }

    public static Heart half(@NotNull HeartDrawing drawing) {
        return Heart.full(drawing, true, CONTAINER_HALF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Heart heart = (Heart)o;
        return this.half == heart.half && this.drawing == heart.drawing && this.backgroundHeart == heart.backgroundHeart;
    }

    public int hashCode() {
        return Objects.hash(this.drawing, this.half, this.backgroundHeart);
    }

    public boolean isContainer() {
        return this == CONTAINER_FULL || this == CONTAINER_HALF;
    }

    public boolean isEmpty() {
        return this == CONTAINER_NONE;
    }

    public void draw(GuiGraphics guiGraphics, int x, int y, boolean hardcore, boolean highlightContainer, boolean highlightHeart) {
        boolean hasBackground;
        if (this.isEmpty()) {
            return;
        }
        boolean bl = hasBackground = this.backgroundHeart != null;
        if (hasBackground) {
            this.backgroundHeart.draw(guiGraphics, x, y, hardcore, highlightContainer, highlightHeart);
            if (this.drawing == Hearts.CONTAINER && this.half) {
                return;
            }
        }
        boolean highlight = this.isContainer() ? highlightContainer : highlightHeart;
        this.drawing.draw(guiGraphics, x, y, this.half, hardcore, highlight);
    }
}

