/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.api.heart.drawing;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;

public class OverlayHeart {
    private final ResourceLocation id;
    private final Predicate<Player> condition;
    private final List<HeartDrawing> healthDrawings;
    private final List<HeartDrawing> absorptionDrawings;
    private final boolean opaque;

    OverlayHeart(ResourceLocation id, Predicate<Player> condition, HeartDrawing h1, HeartDrawing h2, HeartDrawing a1, HeartDrawing a2, boolean opaque) {
        this.id = id;
        this.condition = condition;
        this.healthDrawings = h1 == null || h2 == null ? List.of() : List.of(h1, h2);
        this.absorptionDrawings = a1 == null || a2 == null ? List.of() : List.of(a1, a2);
        this.opaque = opaque;
    }

    public boolean shouldDraw(Player player) {
        return this.condition.test(player);
    }

    public List<HeartDrawing> getHealthDrawings() {
        return this.healthDrawings;
    }

    public List<HeartDrawing> getAbsorptionDrawings() {
        return this.absorptionDrawings;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public String toString() {
        return "OverlayHeart{id=" + String.valueOf(this.id) + ", healthDrawings=" + String.valueOf(this.healthDrawings) + ", absorptionDrawings=" + String.valueOf(this.absorptionDrawings) + "}";
    }

    public static Builder build(ResourceLocation id, Predicate<Player> condition) {
        return new Builder(id, condition);
    }

    public static class Builder {
        final ResourceLocation id;
        final Predicate<Player> condition;
        HeartDrawing healthFirst;
        HeartDrawing healthSecond;
        HeartDrawing absorptionFirst;
        HeartDrawing absorptionSecond;
        boolean opaque;

        Builder(ResourceLocation id, Predicate<Player> condition) {
            this.id = id;
            this.condition = condition;
            this.opaque = true;
        }

        public Builder addHealth(HeartDrawing drawing, float r, float g, float b) {
            return this.addHealth(drawing, r, g, b, 1.0f, 1, 768);
        }

        public Builder addHealth(HeartDrawing drawing, float r, float g, float b, float alpha, int sourceFactor, int destinationFactor) {
            this.healthFirst = drawing;
            this.healthSecond = HeartDrawing.colorBlend(drawing, drawing.getId().withSuffix("_2"), r, g, b, alpha, sourceFactor, destinationFactor);
            return this;
        }

        public Builder addHealth(HeartDrawing first, HeartDrawing second) {
            this.healthFirst = first;
            this.healthSecond = second;
            return this;
        }

        public Builder addHealth(HeartDrawing drawing) {
            this.healthFirst = this.healthSecond = drawing;
            return this;
        }

        public Builder addAbsorption(HeartDrawing drawing, float r, float g, float b) {
            return this.addAbsorption(drawing, r, g, b, 1.0f, 1, 768);
        }

        public Builder addAbsorption(HeartDrawing drawing, float r, float g, float b, float alpha, int sourceFactor, int destinationFactor) {
            this.absorptionFirst = drawing;
            this.absorptionSecond = HeartDrawing.colorBlend(drawing, drawing.getId().withSuffix("_2"), r, g, b, alpha, sourceFactor, destinationFactor);
            return this;
        }

        public Builder addAbsorption(HeartDrawing first, HeartDrawing second) {
            this.absorptionFirst = first;
            this.absorptionSecond = second;
            return this;
        }

        public Builder addAbsorption(HeartDrawing drawing) {
            this.absorptionFirst = this.absorptionSecond = drawing;
            return this;
        }

        public Builder blankAbsorption() {
            this.absorptionFirst = Hearts.CONTAINER;
            this.absorptionSecond = Hearts.CONTAINER;
            return this;
        }

        public Builder transparent() {
            this.opaque = false;
            return this;
        }

        public OverlayHeart finish() {
            if (this.healthFirst == null || this.healthSecond == null || this.absorptionFirst == null || this.absorptionSecond == null) {
                this.opaque = false;
            }
            return new OverlayHeart(this.id, this.condition, this.healthFirst, this.healthSecond, this.absorptionFirst, this.absorptionSecond, this.opaque);
        }
    }
}

