/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.api.room.template.RoomTemplateHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;

public class EnableBasicTemplatesSubcommand {
    static final String PACK_ID = "mod/compactmachines:data/compactmachines/datapacks/basic_templates";

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enable_basic_templates").requires(cs -> cs.hasPermission(2) && RoomTemplateHelper.getTemplates((RegistryAccess)cs.registryAccess()).findAny().isEmpty())).executes(EnableBasicTemplatesSubcommand::exec);
    }

    private static int exec(CommandContext<CommandSourceStack> ctx) {
        PackRepository packrepository = ((CommandSourceStack)ctx.getSource()).getServer().getPackRepository();
        ArrayList list = Lists.newArrayList((Iterable)packrepository.getSelectedPacks());
        if (!packrepository.getSelectedIds().contains(PACK_ID)) {
            Pack pack = packrepository.getPack(PACK_ID);
            if (pack != null) {
                pack.getDefaultPosition().insert((List)list, (Object)pack, Pack::selectionConfig, false);
                ReloadCommand.reloadPacks(list.stream().map(Pack::getId).toList(), (CommandSourceStack)((CommandSourceStack)ctx.getSource()));
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Enabled basic templates, restart game to sync changes."), false);
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Already enabled, restart game to sync changes."));
        }
        return 0;
    }
}

