/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.curios;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.shrinking.PSDTags;
import dev.compactmods.machines.shrinking.Shrinking;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat {
    public static final ResourceLocation PSD_VALIDATOR = CompactMachines.modRL((String)"has_shrinking_config");

    public static void register() {
        CuriosApi.registerCurioPredicate((ResourceLocation)PSD_VALIDATOR, result -> {
            ItemStack stack = result.stack();
            return stack.is(PSDTags.ITEM) || stack.has(Shrinking.DataComponents.SHRINKING_CONFIG);
        });
    }

    public static boolean hasPsdCurio(@Nonnull LivingEntity ent) {
        ICurioStacksHandler inv = CuriosApi.getCuriosInventory((LivingEntity)ent).flatMap(handler -> handler.getStacksHandler("psd")).orElse(null);
        if (inv == null) {
            return false;
        }
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack slotItem = inv.getStacks().getStackInSlot(slot);
            if (slotItem.isEmpty() || !slotItem.has(Shrinking.DataComponents.SHRINKING_CONFIG) && !slotItem.is(PSDTags.ITEM)) continue;
            return true;
        }
        return false;
    }
}

