/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.network.room;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.room.RoomHelper;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PlayerRequestedTeleportPacket(GlobalPos machine, String room) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerRequestedTeleportPacket> TYPE = new CustomPacketPayload.Type(CompactMachines.modRL((String)"player_teleport"));
    public static final StreamCodec<FriendlyByteBuf, PlayerRequestedTeleportPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, PlayerRequestedTeleportPacket::machine, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerRequestedTeleportPacket::room, PlayerRequestedTeleportPacket::new);
    public static final IPayloadHandler<PlayerRequestedTeleportPacket> HANDLER = (pkt, ctx) -> ctx.enqueueWork(() -> {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            RoomHelper.teleportPlayerIntoMachine(player.level(), sp, pkt.machine, pkt.room);
        }
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

