/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.ToasterBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToasterBlock
extends BaseKitchenBlock {
    public static final MapCodec<ToasterBlock> CODEC = ToasterBlock.simpleCodec(ToasterBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)4.4, (double)0.0, (double)4.4, (double)11.6, (double)6.4, (double)11.6);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public ToasterBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(2.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVE});
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ToasterBlockEntity) {
            ToasterBlockEntity toaster = (ToasterBlockEntity)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            if (heldItem.isEmpty() || !toaster.getContainer().getItem(0).isEmpty() && !toaster.getContainer().getItem(1).isEmpty()) {
                if (!(toaster.isActive() || toaster.getContainer().getItem(0).isEmpty() && toaster.getContainer().getItem(1).isEmpty())) {
                    toaster.setActive(!toaster.isActive());
                }
            } else if (toaster.canToast(heldItem)) {
                for (int i = 0; i < toaster.getContainer().getContainerSize(); ++i) {
                    if (!toaster.getContainer().getItem(i).isEmpty()) continue;
                    toaster.getContainer().setItem(i, player.getAbilities().instabuild ? heldItem.copy().split(1) : heldItem.split(1));
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        ToasterBlockEntity tileEntity = (ToasterBlockEntity)world.getBlockEntity(pos);
        if (tileEntity != null && tileEntity.isActive()) {
            boolean burning = tileEntity.isBurningToast();
            float particleChance = tileEntity.getToastProgress();
            int particleCount = 1;
            if (burning) {
                particleChance *= 3.0f;
                particleCount = random.nextInt(1, Math.max(2, (int)Math.ceil(5.0f * tileEntity.getToastProgress())));
            }
            if (random.nextFloat() < particleChance) {
                for (int i = 0; i < particleCount; ++i) {
                    double x = (float)pos.getX() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
                    double y = (float)pos.getY() + 0.2f + random.nextFloat() * 6.0f / 16.0f;
                    double z = (float)pos.getZ() + 0.5f + (random.nextFloat() - 0.5f) * 0.25f;
                    if (burning && Math.random() <= 0.5) {
                        world.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : ToasterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.toaster.get()), ToasterBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.toaster.description").withStyle(ChatFormatting.GRAY));
    }
}

