/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.extradelight;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.simibubi.create.api.packager.unpacking.UnpackingHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import plus.dragons.createcentralkitchen.integration.ModIntegration;
import plus.dragons.createcentralkitchen.integration.extradelight.packager.ChillerUnpackingHandler;
import plus.dragons.createcentralkitchen.integration.extradelight.packager.OvenUnpackingHandler;
import plus.dragons.createcentralkitchen.integration.extradelight.ponder.ExtraDelightPonderPlugin;
import plus.dragons.createcentralkitchen.integration.extradelight.recipe.ExtraDelightRecipeConverters;
import plus.dragons.createcentralkitchen.integration.extradelight.registry.ExtraDelightArmInteractionPointTypes;

@Mod(value="create_central_kitchen")
public class ExtraDelightIntegration {
    public ExtraDelightIntegration(IEventBus modBus) {
        if (ModIntegration.EXTRADELIGHT.enabled()) {
            modBus.register((Object)new Common());
            if (FMLLoader.getDist() == Dist.CLIENT) {
                modBus.register((Object)new Client());
            }
        }
    }

    public static class Common {
        public static final Set<Collection<RecipeHolder<? extends Recipe<?>>>> RELOADABLE_RECIPES = new HashSet();
        private static final ResourceManagerReloadListener RELOAD_LISTENER = resourceManager -> RELOADABLE_RECIPES.forEach(Collection::clear);

        @SubscribeEvent
        public void construct(FMLConstructModEvent event) {
            ExtraDelightArmInteractionPointTypes.register();
            NeoForge.EVENT_BUS.register(ExtraDelightRecipeConverters.class);
            NeoForge.EVENT_BUS.addListener(Common::addReloadListeners);
        }

        @SubscribeEvent
        public void setup(FMLCommonSetupEvent event) {
            event.enqueueWork(this::registerUnpackingHandlers);
        }

        private void registerUnpackingHandlers() {
            ((BlockEntityType)ExtraDelightBlockEntities.OVEN.get()).getValidBlocks().forEach(block -> UnpackingHandler.REGISTRY.register(block, (Object)new OvenUnpackingHandler()));
            ((BlockEntityType)ExtraDelightBlockEntities.CHILLER.get()).getValidBlocks().forEach(block -> UnpackingHandler.REGISTRY.register(block, (Object)new ChillerUnpackingHandler()));
        }

        public static void addReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)RELOAD_LISTENER);
        }
    }

    public static class Client {
        @SubscribeEvent
        public void construct(FMLConstructModEvent event) {
            ExtraDelightPonderPlugin.register();
        }
    }
}

