/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids;

import java.util.Optional;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public interface WaterAndLavaLoggedBlock
extends BucketPickup,
LiquidBlockContainer {
    public static final EnumProperty<ContainedFluid> FLUID = EnumProperty.create((String)"fluid", ContainedFluid.class);

    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid == Fluids.WATER || fluid == Fluids.LAVA;
    }

    default public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        ContainedFluid containedFluid = (ContainedFluid)((Object)state.getValue(FLUID));
        if (containedFluid != ContainedFluid.EMPTY) {
            return false;
        }
        Fluid placedFluid = fluidState.getType();
        if (placedFluid == Fluids.WATER) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)ContainedFluid.WATER)), 3);
                level.scheduleTick(pos, placedFluid, placedFluid.getTickDelay((LevelReader)level));
            }
            return true;
        }
        if (placedFluid == Fluids.LAVA) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)ContainedFluid.LAVA)), 3);
                level.scheduleTick(pos, placedFluid, placedFluid.getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        ContainedFluid containedFluid = (ContainedFluid)((Object)state.getValue(FLUID));
        if (containedFluid == ContainedFluid.EMPTY) {
            return ItemStack.EMPTY;
        }
        level.setBlock(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)ContainedFluid.EMPTY)), 3);
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
        return containedFluid == ContainedFluid.WATER ? new ItemStack((ItemLike)Items.WATER_BUCKET) : new ItemStack((ItemLike)Items.LAVA_BUCKET);
    }

    default public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return switch (((ContainedFluid)((Object)state.getValue(FLUID))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.empty();
            case 1 -> Fluids.WATER.getPickupSound();
            case 2 -> Fluids.LAVA.getPickupSound();
        };
    }

    default public FluidState fluidState(BlockState state) {
        return switch (((ContainedFluid)((Object)state.getValue(FLUID))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Fluids.EMPTY.defaultFluidState();
            case 1 -> Fluids.WATER.getSource(false);
            case 2 -> Fluids.LAVA.getSource(false);
        };
    }

    default public void updateFluid(LevelAccessor level, BlockState state, BlockPos pos) {
        switch (((ContainedFluid)((Object)state.getValue(FLUID))).ordinal()) {
            case 1: {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                break;
            }
            case 2: {
                level.scheduleTick(pos, (Fluid)Fluids.LAVA, Fluids.LAVA.getTickDelay((LevelReader)level));
            }
        }
    }

    default public BlockState withFluid(BlockState placementState, BlockPlaceContext ctx) {
        return WaterAndLavaLoggedBlock.withFluid((LevelAccessor)ctx.getLevel(), placementState, ctx.getClickedPos());
    }

    public static BlockState withFluid(LevelAccessor level, BlockState placementState, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        if (placementState.isAir()) {
            return fluidState.isEmpty() ? placementState : fluidState.createLegacyBlock();
        }
        if (!(placementState.getBlock() instanceof WaterAndLavaLoggedBlock)) {
            return placementState;
        }
        ContainedFluid containedFluid = fluidState.getType() == Fluids.WATER ? ContainedFluid.WATER : (fluidState.getType() == Fluids.LAVA ? ContainedFluid.LAVA : ContainedFluid.EMPTY);
        return (BlockState)placementState.setValue(FLUID, (Comparable)((Object)containedFluid));
    }

    public static enum ContainedFluid implements StringRepresentable
    {
        EMPTY,
        WATER,
        LAVA;


        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }
    }
}

