/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.client;

import com.adonis.createshimmer.common.registry.CSEffects;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class CSShimmerClientHandler {
    private static final DustParticleOptions PURPLE_DUST = new DustParticleOptions(new Vector3f(0.6039216f, 0.3019608f, 1.0f), 1.0f);
    private static final Map<UUID, Long> PARTICLE_LINE_TARGETS = new LinkedHashMap<UUID, Long>();
    private static final long MAX_DURATION = 8000L;

    public static void addParticleLineTarget(UUID uuid, long startTime) {
        PARTICLE_LINE_TARGETS.put(uuid, startTime);
    }

    @SubscribeEvent
    public static void onClientLevelTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            CSShimmerClientHandler.tickParticleLines();
        }
    }

    private static void tickParticleLines() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (!mc.player.hasEffect(CSEffects.SHIMMER_EFFECT)) {
            PARTICLE_LINE_TARGETS.clear();
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Long>> iterator = PARTICLE_LINE_TARGETS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            UUID uuid = entry.getKey();
            long startTime = entry.getValue();
            if (currentTime - startTime > 8000L) {
                iterator.remove();
                continue;
            }
            LivingEntity target = null;
            for (Entity entity : mc.level.entitiesForRendering()) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).getUUID().equals(uuid) || !living.isAlive()) continue;
                target = living;
                break;
            }
            if (target == null) {
                iterator.remove();
                continue;
            }
            Vec3 playerFeetPos = new Vec3(mc.player.getX(), mc.player.getY(), mc.player.getZ());
            Vec3 targetFeetPos = new Vec3(target.getX(), target.getY(), target.getZ());
            Vec3 direction = new Vec3(playerFeetPos.x - targetFeetPos.x, playerFeetPos.y - targetFeetPos.y, playerFeetPos.z - targetFeetPos.z);
            double distance = direction.length();
            if (distance > 64.0 || distance < 0.5) {
                iterator.remove();
                continue;
            }
            direction = direction.normalize();
            int particleCount = 8 + (int)(distance / 4.0);
            for (int i = 0; i < particleCount; ++i) {
                double progress = (double)i / (double)particleCount;
                double curve = Math.pow(progress, 0.7);
                double baseX = targetFeetPos.x + direction.x * distance * curve;
                double baseY = targetFeetPos.y + direction.y * distance * curve;
                double baseZ = targetFeetPos.z + direction.z * distance * curve;
                double yOffset = 0.2 + Math.sin(progress * Math.PI) * 0.6;
                double xOffset = (mc.level.random.nextDouble() - 0.5) * 0.3;
                double zOffset = (mc.level.random.nextDouble() - 0.5) * 0.3;
                double x = baseX + xOffset;
                double y = baseY + yOffset;
                double z = baseZ + zOffset;
                double speed = 0.03 + progress * 0.08;
                double vx = direction.x * speed + (mc.level.random.nextDouble() - 0.5) * 0.02;
                double vy = direction.y * speed + 0.02 + (mc.level.random.nextDouble() - 0.5) * 0.01;
                double vz = direction.z * speed + (mc.level.random.nextDouble() - 0.5) * 0.02;
                mc.level.addParticle((ParticleOptions)PURPLE_DUST, x, y, z, vx, vy, vz);
            }
        }
    }
}

