/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.kinetics.fan.glooming;

import com.adonis.createshimmer.common.kinetics.fan.glooming.GloomingRecipe;
import com.adonis.createshimmer.common.registry.CSBlocks;
import com.adonis.createshimmer.common.registry.CSFluids;
import com.adonis.createshimmer.common.registry.CSRecipes;
import com.adonis.createshimmer.config.CSConfig;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFParticleType;

public class GloomingFanProcessingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        boolean configEnabled = (Boolean)CSConfig.recipes().enableBulkGlooming.get();
        if (!configEnabled) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(CSBlocks.MOD_TAGS.fanGloomingCatalysts)) {
            return true;
        }
        FluidState fluidState = level.getFluidState(pos);
        return fluidState.is(CSFluids.MOD_TAGS.fanGloomingCatalysts);
    }

    public int getPriority() {
        return 380;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CSRecipes.GLOOMING.getType(), (RecipeInput)input, level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CSRecipes.GLOOMING.getType(), (RecipeInput)input, level).map(recipe -> ((GloomingRecipe)recipe.value()).rollResults(level.random)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(6) == 0) {
            level.addParticle((ParticleOptions)TFParticleType.OMINOUS_FLAME.get(), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), (double)((level.random.nextFloat() - 0.5f) * 0.1f), (double)0.15f, (double)((level.random.nextFloat() - 0.5f) * 0.1f));
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)6950317, (int)9662683, (float)random.nextFloat()));
        particleAccess.setAlpha(0.7f);
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (!entity.getType().is(EntityTypeTags.UNDEAD) && entity.tickCount % 5 == 0) {
            entity.hurt(TFDamageTypes.getDamageSource((Level)level, (ResourceKey)TFDamageTypes.OMINOUS_FIRE, (EntityType[])new EntityType[0]), 1.0f);
        }
    }
}

