/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.util.ScepterRepairHelper;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProcessingRecipe.class}, remap=false)
public class ProcessingRecipeMixin {
    @Inject(method={"getResultItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetResultItem(HolderLookup.Provider registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        FillingRecipe fillingRecipe;
        ProcessingRecipe recipe = (ProcessingRecipe)this;
        if (recipe instanceof FillingRecipe && this.isShimmerRepairRecipe(fillingRecipe = (FillingRecipe)recipe) && !fillingRecipe.getRollableResults().isEmpty()) {
            ItemStack result = ((ProcessingOutput)fillingRecipe.getRollableResults().get(0)).getStack().copy();
            cir.setReturnValue((Object)result);
            return;
        }
    }

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(RecipeInput input, HolderLookup.Provider registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        ProcessingRecipe recipe = (ProcessingRecipe)this;
        if (recipe instanceof FillingRecipe) {
            SingleRecipeInput singleInput;
            ItemStack inputStack;
            FillingRecipe fillingRecipe = (FillingRecipe)recipe;
            if (input instanceof SingleRecipeInput && ScepterRepairHelper.isRepairableScepter(inputStack = (singleInput = (SingleRecipeInput)input).getItem(0)) && ScepterRepairHelper.needsRepair(inputStack) && this.isShimmerRepairRecipe(fillingRecipe)) {
                ItemStack baseResult = !fillingRecipe.getRollableResults().isEmpty() ? ((ProcessingOutput)fillingRecipe.getRollableResults().get(0)).getStack().copy() : inputStack.copy();
                if (baseResult.getItem() != inputStack.getItem()) {
                    baseResult = inputStack.copy();
                }
                ItemStack repairedScepter = ScepterRepairHelper.repairScepter(baseResult);
                cir.setReturnValue((Object)repairedScepter);
                return;
            }
        }
    }

    private boolean isShimmerRepairRecipe(FillingRecipe recipe) {
        try {
            boolean hasScepterInput = false;
            NonNullList ingredients = recipe.getIngredients();
            if (!ingredients.isEmpty()) {
                ItemStack[] items;
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                for (ItemStack item : items = ingredient.getItems()) {
                    if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                    hasScepterInput = true;
                    break;
                }
            }
            if (!hasScepterInput) {
                return false;
            }
            if (!recipe.getFluidIngredients().isEmpty()) {
                FluidStack[] matchingFluids;
                SizedFluidIngredient sizedFluidIngredient = (SizedFluidIngredient)recipe.getFluidIngredients().get(0);
                FluidIngredient fluidIngredient = sizedFluidIngredient.ingredient();
                for (FluidStack fluidStack : matchingFluids = fluidIngredient.getStacks()) {
                    ResourceLocation fluidName = BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid());
                    if (fluidName == null || !fluidName.toString().contains("shimmer")) continue;
                    return true;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

