/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.fan;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableFanProcessing;", "", "efficiencyLevel", "", "<init>", "(I)V", "canProcess", "", "entity", "Lnet/minecraft/world/entity/item/ItemEntity;", "type", "Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;", "applyProcessing", "Lcom/simibubi/create/content/kinetics/belt/behaviour/TransportedItemStackHandlerBehaviour$TransportedResult;", "transported", "Lcom/simibubi/create/content/kinetics/belt/transport/TransportedItemStack;", "world", "Lnet/minecraft/world/level/Level;", "decrementProcessingTime", "createenchantablemachinery"})
@SourceDebugExtension(value={"SMAP\nEnchantableFanProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantableFanProcessing.kt\nio/github/cotrin8672/cem/content/block/fan/EnchantableFanProcessing\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class EnchantableFanProcessing {
    private final int efficiencyLevel;

    public EnchantableFanProcessing(int efficiencyLevel) {
        this.efficiencyLevel = efficiencyLevel;
    }

    public final boolean canProcess(@NotNull ItemEntity entity, @NotNull FanProcessingType type) {
        CompoundTag compound;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (entity.getPersistentData().contains("CreateData") && (compound = entity.getPersistentData().getCompound("CreateData")).contains("Processing")) {
            CompoundTag processing = compound.getCompound("Processing");
            if (AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
                return type.canProcess(entity.getItem(), entity.level());
            }
            if (processing.getInt("Time") >= 0) {
                return true;
            }
            if (processing.getInt("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.getItem(), entity.level());
    }

    public final boolean applyProcessing(@NotNull ItemEntity entity, @NotNull FanProcessingType type) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List list = type.process(entity.getItem(), entity.level());
        if (list == null) {
            return false;
        }
        List stacks = list;
        if (stacks.isEmpty()) {
            entity.discard();
            return false;
        }
        entity.setItem((ItemStack)stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), additional);
            entityIn.setDeltaMovement(entity.getDeltaMovement());
            entity.level().addFreshEntity((Entity)entityIn);
        }
        return true;
    }

    @NotNull
    public final TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(@NotNull TransportedItemStack transported, @Nullable Level world, @NotNull FanProcessingType type) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.getCount() - 1) / 16 + 1;
            double efficiencyLevelModifier = (double)1.0f - (double)this.efficiencyLevel * 0.1;
            int processingTime = ((Number)AllConfigs.server().kinetics.fanProcessingTime.get()).intValue() * timeModifierForStackSize + 1;
            transported.processingTime = (int)((double)processingTime * efficiencyLevelModifier);
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        if (transported.processingTime == -1) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        int timeModifierForStackSize = transported.processingTime;
        transported.processingTime = timeModifierForStackSize + -1;
        if (timeModifierForStackSize > 0) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        List list = type.process(transported.stack, world);
        if (list == null) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        List stacks = list;
        List transportedStacks = new ArrayList();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.copy();
            Intrinsics.checkNotNull((Object)newTransported);
            transportedStacks.add(newTransported);
        }
        TransportedItemStackHandlerBehaviour.TransportedResult transportedResult = TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((List)transportedStacks);
        Intrinsics.checkNotNullExpressionValue((Object)transportedResult, (String)"convertTo(...)");
        return transportedResult;
    }

    private final int decrementProcessingTime(ItemEntity entity, FanProcessingType type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.contains("CreateData")) {
            nbt.put("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.getCompound("CreateData")).contains("Processing")) {
            createData.put("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.getCompound("Processing")).contains("Type") || AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
            ResourceLocation key = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.getKey((Object)type);
            if (key == null) {
                boolean $i$a$-requireNotNull-EnchantableFanProcessing$decrementProcessingTime$22 = false;
                String $i$a$-requireNotNull-EnchantableFanProcessing$decrementProcessingTime$22 = "Could not get id for FanProcessingType " + type + "!";
                throw new IllegalArgumentException($i$a$-requireNotNull-EnchantableFanProcessing$decrementProcessingTime$22.toString());
            }
            processing.putString("Type", key.toString());
            int timeModifierForStackSize = (entity.getItem().getCount() - 1) / 16 + 1;
            int processingTime = ((Number)AllConfigs.server().kinetics.fanProcessingTime.get()).intValue() * timeModifierForStackSize + 1;
            double efficiencyModifier = (double)1.0f - (double)this.efficiencyLevel * 0.1;
            processing.putInt("Time", (int)((double)processingTime * efficiencyModifier));
        }
        int value = processing.getInt("Time") - 1;
        processing.putInt("Time", value);
        return value;
    }
}

