/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.spout;

import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin;
import io.github.cotrin8672.cem.registry.BlockEntityRegistration;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\b\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020\u0018H\u0002J\u001e\u00104\u001a\u00020\u00182\f\u00105\u001a\b\u0012\u0004\u0012\u0002060)2\u0006\u00107\u001a\u00020\u0018H\u0016J \u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0018H\u0014J \u0010>\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0018H\u0014J\u0017\u0010?\u001a\u00020\f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0096\u0001J\t\u0010C\u001a\u00020DH\u0096\u0001J\u0019\u0010E\u001a\u00020'2\u0006\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020<H\u0096\u0001J\u0011\u0010H\u001a\u00020'2\u0006\u0010I\u001a\u00020DH\u0096\u0001J\u0019\u0010J\u001a\u00020'2\u0006\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020<H\u0096\u0001R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010!\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006L"}, d2={"Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutBlockEntity;", "Lcom/simibubi/create/content/fluids/spout/SpoutBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "enchantedFillingTime", "", "getEnchantedFillingTime", "()I", "executionTick", "getExecutionTick", "spawnParticleTick", "getSpawnParticleTick", "fluidTank", "Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;", "getFluidTank", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;", "value", "", "createdSweetRoll", "getCreatedSweetRoll", "()Z", "setCreatedSweetRoll", "(Z)V", "createdHoneyApple", "getCreatedHoneyApple", "setCreatedHoneyApple", "createdChocolateBerries", "getCreatedChocolateBerries", "setCreatedChocolateBerries", "getCurrentFluidInTank", "Lnet/neoforged/neoforge/fluids/FluidStack;", "addBehaviours", "", "behaviours", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "onItemReceived", "Lcom/simibubi/create/content/kinetics/belt/behaviour/BeltProcessingBehaviour$ProcessingResult;", "transported", "Lcom/simibubi/create/content/kinetics/belt/transport/TransportedItemStack;", "handler", "Lcom/simibubi/create/content/kinetics/belt/behaviour/TransportedItemStackHandlerBehaviour;", "whenItemHeld", "tick", "trackFoods", "addToGoggleTooltip", "tooltip", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "write", "getEnchantmentLevel", "enchantment", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantments", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "readEnchantments", "tag", "provider", "setEnchantment", "enchantments", "writeEnchantments", "Companion", "createenchantablemachinery"})
public final class EnchantableSpoutBlockEntity
extends SpoutBlockEntity
implements EnchantableBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableSpoutBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    public final int getEnchantedFillingTime() {
        BlockEntity blockEntity = (BlockEntity)this;
        ResourceKey resourceKey = Registries.ENCHANTMENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENCHANTMENT");
        Holder.Reference efficiency = BlockEntityExtensionKt.holderLookup(blockEntity, resourceKey).getOrThrow(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNull((Object)efficiency);
        int efficiencyModifier = 2 * this.getEnchantmentLevel((Holder<Enchantment>)((Holder)efficiency));
        return Math.max(1, 20 - efficiencyModifier);
    }

    public final int getExecutionTick() {
        return Math.max(0, (int)Math.ceil((float)this.getEnchantedFillingTime() / 4.0f));
    }

    private final int getSpawnParticleTick() {
        return Math.max(0, this.getEnchantedFillingTime() * 2 / 5);
    }

    @NotNull
    public final SmartFluidTankBehaviour getFluidTank() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        SmartFluidTankBehaviour smartFluidTankBehaviour = ((SpoutBlockEntityMixin)((Object)this)).getTank();
        Intrinsics.checkNotNullExpressionValue((Object)smartFluidTankBehaviour, (String)"getTank(...)");
        return smartFluidTankBehaviour;
    }

    private final boolean getCreatedSweetRoll() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedSweetRoll();
    }

    private final void setCreatedSweetRoll(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedSweetRoll(value);
    }

    private final boolean getCreatedHoneyApple() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedHoneyApple();
    }

    private final void setCreatedHoneyApple(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedHoneyApple(value);
    }

    private final boolean getCreatedChocolateBerries() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedChocolateBerries();
    }

    private final void setCreatedChocolateBerries(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedChocolateBerries(value);
    }

    private final FluidStack getCurrentFluidInTank() {
        FluidStack fluidStack = this.getFluidTank().getPrimaryHandler().getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
        return fluidStack;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
    }

    @NotNull
    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(@NotNull TransportedItemStack transported, @NotNull TransportedItemStackHandlerBehaviour handler) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.getFluidTank().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)transported.stack, (FluidStack)this.getCurrentFluidInTank()) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    @NotNull
    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(@NotNull TransportedItemStack transported, @NotNull TransportedItemStackHandlerBehaviour handler) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (this.processingTicks != -1 && this.processingTicks != this.getExecutionTick()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (ItemStack)transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.getFluidTank().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (ItemStack)transported.stack, (FluidStack)fluid.copy());
        if (requiredAmountForItem == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = this.getEnchantedFillingTime();
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack out = FillingBySpout.fillItem((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (int)requiredAmountForItem, (ItemStack)transported.stack, (FluidStack)fluid);
        if (!out.isEmpty()) {
            List outList = new ArrayList();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.isEmpty()) {
                held = transported.copy();
            }
            Intrinsics.checkNotNull((Object)result);
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld((List)outList, (TransportedItemStack)held));
        }
        this.award(AllAdvancements.SPOUT);
        if (this.trackFoods()) {
            this.setCreatedChocolateBerries(this.getCreatedChocolateBerries() | AllItems.CHOCOLATE_BERRIES.isIn(out));
            this.setCreatedHoneyApple(this.getCreatedHoneyApple() | AllItems.HONEYED_APPLE.isIn(out));
            this.setCreatedSweetRoll(this.getCreatedSweetRoll() | AllItems.SWEET_ROLL.isIn(out));
            if (this.getCreatedChocolateBerries() && this.getCreatedHoneyApple() && this.getCreatedSweetRoll()) {
                this.award(AllAdvancements.FOODS);
            }
        }
        this.getFluidTank().getPrimaryHandler().setFluid(fluid);
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public void tick() {
        BlockEntityExtensionKt.smartBlockEntityTick((SmartBlockEntity)this);
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (!(this.processingTicks != -1 || !this.isVirtual() && BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this).isClientSide() || currentFluidInTank.isEmpty())) {
            BlockPos filling = this.worldPosition.below(2);
            BlockSpoutingBehaviour behaviour = BlockSpoutingBehaviour.get((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (BlockPos)filling);
            if (behaviour != null && behaviour.fillBlock(this.level, filling, (SpoutBlockEntity)this, currentFluidInTank.copy(), true) > 0) {
                this.processingTicks = this.getEnchantedFillingTime();
                this.customProcess = behaviour;
                this.notifyUpdate();
            }
        }
        if (this.processingTicks >= 0) {
            int filling = this.processingTicks;
            this.processingTicks = filling + -1;
            if (this.processingTicks == this.getExecutionTick() && this.customProcess != null) {
                int fillBlock = this.customProcess.fillBlock(this.level, this.worldPosition.below(2), (SpoutBlockEntity)this, currentFluidInTank.copy(), false);
                this.customProcess = null;
                if (fillBlock > 0) {
                    this.getFluidTank().getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - fillBlock)));
                    this.sendSplash = true;
                    this.notifyUpdate();
                }
            }
        }
        if (this.processingTicks >= this.getSpawnParticleTick() && BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).isClientSide) {
            this.spawnProcessingParticles(this.getFluidTank().getPrimaryTank().getRenderedFluid());
        }
    }

    private final boolean trackFoods() {
        return ((AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent();
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getEnchantments().entrySet().isEmpty()) {
            return false;
        }
        for (Object2IntMap.Entry instance : this.getEnchantments().entrySet()) {
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(Enchantment.getFullname((Holder)((Holder)instance.getKey()), (int)instance.getIntValue())).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.readEnchantments(compound, registries);
        super.read(compound, registries, clientPacket);
    }

    protected void write(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.writeEnchantments(compound, registries);
        super.write(compound, registries, clientPacket);
    }

    @Override
    @NotNull
    public ItemEnchantments getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    public void setEnchantment(@NotNull ItemEnchantments enchantments) {
        Intrinsics.checkNotNullParameter((Object)enchantments, (String)"enchantments");
        this.$$delegate_0.setEnchantment(enchantments);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Holder<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        return this.$$delegate_0.getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.readEnchantments(tag, provider);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.writeEnchantments(tag, provider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "getCap", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "be", "Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutBlockEntity;", "context", "Lnet/minecraft/core/Direction;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntityRegistration.INSTANCE.getENCHANTABLE_SPOUT().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$0((Function2)new Function2<EnchantableSpoutBlockEntity, Direction, IFluidHandler>((Object)this){

                public final IFluidHandler invoke(EnchantableSpoutBlockEntity p0, Direction p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Companion)this.receiver).getCap(p0, p1);
                }
            }, arg_0, arg_1));
        }

        @Nullable
        public final IFluidHandler getCap(@NotNull EnchantableSpoutBlockEntity be, @Nullable Direction context) {
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            return context != Direction.DOWN ? be.getFluidTank().getCapability() : null;
        }

        private static final IFluidHandler registerCapabilities$lambda$0(Function2 $tmp0, Object p0, Direction p1) {
            return (IFluidHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

