/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.createenderstorage.contraption;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import us.drullk.createenderstorage.CreateEnderStorage;

public class EnderChestMountedStorage
extends MountedItemStorage {
    public static final MapCodec<EnderChestMountedStorage> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Frequency.CODEC.fieldOf("chest_frequency").forGetter(EnderChestMountedStorage::getFrequency), (App)Codec.INT.fieldOf("rotation").forGetter(EnderChestMountedStorage::getRotation)).apply((Applicative)inst, EnderChestMountedStorage::new));
    private final Frequency frequency;
    private final int rotation;
    @Nullable
    private IItemHandler itemHandler;
    @Nullable
    private EnderItemStorage storage;

    protected EnderChestMountedStorage(Frequency frequency, int rotation) {
        super((MountedItemStorageType)CreateEnderStorage.ENDER_CHEST.value());
        this.frequency = frequency;
        this.rotation = rotation;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public int getRotation() {
        return this.rotation;
    }

    public IItemHandler getItemHandler() {
        if (this.itemHandler == null) {
            this.itemHandler = new InvWrapper((Container)this.getStorage());
        }
        return this.itemHandler;
    }

    public EnderItemStorage getStorage() {
        if (this.storage == null) {
            this.storage = (EnderItemStorage)EnderStorageManager.instance((boolean)false).getStorage(this.frequency, EnderItemStorage.TYPE);
        }
        return this.storage;
    }

    public void unmount(Level level, BlockState blockState, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        if (!(blockEntity instanceof TileEnderChest)) {
            return;
        }
        TileEnderChest enderChest = (TileEnderChest)blockEntity;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(blockPos, blockState);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockPos), false)) {
                player.connection.send((Packet)packet);
            }
        }
        enderChest.rotation = Math.floorMod(this.rotation, 4);
        enderChest.setFreq(this.frequency);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.getStorage().setItem(slot, stack);
    }

    public int getSlots() {
        return EnderItemStorage.sizes[EnderStorageConfig.storageSize];
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getStorage().getItem(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.getItemHandler().insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getItemHandler().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getItemHandler().getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getItemHandler().isItemValid(slot, stack);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        MutableComponent enderChestName = Component.translatable((String)info.state().getBlock().getDescriptionId());
        MutableComponent movingName = CreateLang.translateDirect((String)"contraptions.moving_container", (Object[])new Object[]{enderChestName});
        this.getStorage().openContainer(player, (Component)movingName);
        return true;
    }
}

