/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.createenderstorage.contraption;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileEnderTank;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import us.drullk.createenderstorage.CreateEnderStorage;

public class EnderTankMountedStorage
extends MountedFluidStorage {
    public static final MapCodec<EnderTankMountedStorage> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Frequency.CODEC.fieldOf("tank_frequency").forGetter(EnderTankMountedStorage::getFrequency), (App)Codec.INT.fieldOf("rotation").forGetter(EnderTankMountedStorage::getRotation)).apply((Applicative)inst, EnderTankMountedStorage::new));
    private final Frequency frequency;
    private final int rotation;
    @Nullable
    private EnderLiquidStorage storage;

    protected EnderTankMountedStorage(Frequency frequency, int rotation) {
        super((MountedFluidStorageType)CreateEnderStorage.ENDER_TANK.value());
        this.frequency = frequency;
        this.rotation = rotation;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public int getRotation() {
        return this.rotation;
    }

    public EnderLiquidStorage getStorage() {
        if (this.storage == null) {
            this.storage = (EnderLiquidStorage)EnderStorageManager.instance((boolean)false).getStorage(this.frequency, EnderLiquidStorage.TYPE);
        }
        return this.storage;
    }

    public void unmount(Level level, BlockState blockState, BlockPos blockPos, @Nullable BlockEntity blockEntity) {
        if (!(blockEntity instanceof TileEnderTank)) {
            return;
        }
        TileEnderTank enderTank = (TileEnderTank)blockEntity;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(blockPos, blockState);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockPos), false)) {
                player.connection.send((Packet)packet);
            }
        }
        enderTank.rotation = Math.floorMod(this.rotation - 1, 4);
        enderTank.setFreq(this.frequency);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getStorage().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getStorage().getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getStorage().isFluidValid(tank, stack);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return this.getStorage().fill(stack, action);
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        return this.getStorage().drain(stack, action);
    }

    public FluidStack drain(int tank, IFluidHandler.FluidAction action) {
        return this.getStorage().drain(tank, action);
    }
}

