/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix;

import dev.satherov.crystalix.client.KeybindManager;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.common.block.CrystalixGlassTile;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.common.properties.IProperty;
import dev.satherov.crystalix.config.CSClientConfig;
import dev.satherov.crystalix.core.CSRegistry;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="crystalix", dist={Dist.CLIENT})
@EventBusSubscriber(modid="crystalix", value={Dist.CLIENT})
public class CrystalixClient {
    public CrystalixClient(FMLModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(KeybindManager.SCREEN_OPENER);
        event.register(KeybindManager.COPY_PROPERTIES);
        event.register(KeybindManager.APPLY_COLORLESS);
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiEvent.Post event) {
        if (CSClientConfig.getWandInfo() == CSClientConfig.AnchorPosition.NONE) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack wand = CrystalixWand.find((Player)mc.player);
        if (wand.isEmpty()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        CSProperties properties = CSProperties.of(wand);
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(properties.properties().values().stream().map(IProperty::text).toList());
        lines.add(CSLanguage.PROPERTY_APPLY_COLORLESS.text(ChatFormatting.GRAY, (Boolean)wand.get(CSRegistry.APPLY_COLORLESS) != false ? CSLanguage.PROPERTY_ENABLED.text(ChatFormatting.DARK_GREEN) : CSLanguage.PROPERTY_DISABLED.text(ChatFormatting.DARK_RED)));
        int maxTextWidth = 0;
        for (Component component : lines) {
            int textWidth = mc.font.width((FormattedText)component);
            if (textWidth <= maxTextWidth) continue;
            maxTextWidth = textWidth;
        }
        int boxWidth = maxTextWidth + 20;
        int n = lines.size();
        Objects.requireNonNull(mc.font);
        int n2 = n * (9 + 1) + 20;
        int boxX = CSClientConfig.getWandInfo() == CSClientConfig.AnchorPosition.TOP_LEFT ? 10 : screenWidth - boxWidth - 10;
        int boxY = 10;
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + n2, -2012147439);
        guiGraphics.renderOutline(boxX, boxY, boxWidth, n2, -1154272461);
        int textX = boxX + 10;
        int textY = boxY + 10;
        for (int i = 0; i < lines.size(); ++i) {
            Component line = (Component)lines.get(i);
            guiGraphics.drawString(mc.font, line, textX, textY, -15790321);
            if (i >= lines.size() - 1) continue;
            Objects.requireNonNull(mc.font);
            textY += 9 + 1;
        }
    }

    @SubscribeEvent
    public static void renderTypeSetup(EntityRenderersEvent.RegisterRenderers event) {
        CSRegistry.ENTRIES.forEach((types, holder) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)holder.get()), (RenderType)RenderType.translucent()));
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        CSRegistry.ENTRIES.forEach((type, holder) -> event.register((state, getter, pos, idx) -> {
            BlockEntity patt0$temp;
            if (getter != null && pos != null && (patt0$temp = getter.getBlockEntity(pos)) instanceof CrystalixGlassTile) {
                CrystalixGlassTile tile = (CrystalixGlassTile)patt0$temp;
                return tile.getColor();
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)holder.get()}));
    }
}

