/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.properties;

import com.google.common.base.Suppliers;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.properties.IProperty;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CSEnumProperty<E extends Enum<E>>
implements IProperty<E> {
    private final ItemStack stack;
    private final ResourceLocation location;
    private final String translation;
    private final CSTranslatable description;
    private final String key;
    private final Supplier<DataComponentType<E>> type;
    private final Class<E> clazz;
    private E value;

    protected CSEnumProperty(ItemStack stack, CSTranslatable translation, CSTranslatable tooltip, ResourceLocation location, Class<E> clazz, E defaultValue, Supplier<DataComponentType<E>> supplier) {
        this.stack = stack;
        this.location = location;
        this.clazz = clazz;
        this.translation = translation.translation();
        this.description = tooltip;
        this.key = translation.key();
        this.type = Suppliers.memoize(supplier::get);
        this.value = (Enum)stack.getOrDefault(this.type, defaultValue);
    }

    public static <E extends Enum<E>> CSEnumProperty<E> create(ItemStack stack, CSTranslatable translation, CSTranslatable tooltip, ResourceLocation location, Class<E> clazz, E defaultValue, Supplier<DataComponentType<E>> supplier) {
        return new CSEnumProperty<E>(stack, translation, tooltip, location, clazz, defaultValue, supplier);
    }

    @Override
    public E next(boolean forward) {
        Enum[] values = (Enum[])this.clazz.getEnumConstants();
        int i = ((Enum)this.value).ordinal() + (forward ? 1 : -1);
        if (i < 0) {
            i += values.length;
        }
        return (E)this.set((E)values[i % values.length]);
    }

    @Override
    public E set(E value) {
        this.value = value;
        this.stack.set(this.type, this.value);
        return this.value;
    }

    @Override
    public DataComponentType<E> type() {
        return this.type.get();
    }

    @Override
    public MutableComponent name() {
        return Component.translatable((String)this.key);
    }

    @Override
    public MutableComponent display() {
        return ((CSTranslatable)this.value).text();
    }

    @Override
    public MutableComponent tooltip() {
        return this.description.text();
    }

    @Override
    @Generated
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    @Generated
    public String translation() {
        return this.translation;
    }

    @Generated
    public CSTranslatable description() {
        return this.description;
    }

    @Override
    @Generated
    public String key() {
        return this.key;
    }

    @Override
    @Generated
    public E value() {
        return this.value;
    }
}

