/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.properties;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public class EnumCodecs {
    public static <E extends Enum<E>> Codec<E> makeCodec(Class<E> enumClass) {
        return StringRepresentable.fromEnum(enumClass::getEnumConstants);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> makeStreamCodec(Class<E> enumClass) {
        return ByteBufCodecs.idMapper(EnumCodecs.makeById(enumClass), rec$ -> ((Enum)rec$).ordinal());
    }

    private static <E extends Enum<E>> IntFunction<E> makeById(Class<E> enumClass) {
        return ByIdMap.continuous(rec$ -> ((Enum)rec$).ordinal(), (Object[])((Enum[])enumClass.getEnumConstants()), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
    }
}

