/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core.network;

import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.common.properties.IProperty;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CyclePropertyPayload(ResourceLocation key, boolean dir) implements CustomPacketPayload
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CyclePropertyPayload.class);
    public static final StreamCodec<FriendlyByteBuf, CyclePropertyPayload> STREAM_CODEC = CustomPacketPayload.codec(CyclePropertyPayload::encode, CyclePropertyPayload::new);
    public static final CustomPacketPayload.Type<CyclePropertyPayload> TYPE = new CustomPacketPayload.Type(Crystalix.rl("cycle_property"));

    private CyclePropertyPayload(FriendlyByteBuf buffer) {
        this(ResourceLocation.parse((String)buffer.readUtf(100)), buffer.readBoolean());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.key.toString());
        buffer.writeBoolean(this.dir);
    }

    public static void handle(CyclePropertyPayload message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp;
            if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack wand = CrystalixWand.find((Player)player);
                if (wand.isEmpty()) {
                    return;
                }
                CSProperties properties = CSProperties.of(wand);
                IProperty<?> property = properties.properties().get(message.key());
                if (property == null) {
                    log.warn("Unknown property: {}", (Object)message.key());
                    return;
                }
                property.next(message.dir());
                player.getInventory().setChanged();
            }
        }).exceptionally(e -> {
            ctx.disconnect((Component)CSLanguage.NETWORK_CYCLE_FAILED.text(e.getMessage()));
            return null;
        });
    }
}

