/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core.network;

import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSIntegerProperty;
import dev.satherov.crystalix.common.properties.CSProperties;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetColorPayload(int color) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SetColorPayload> STREAM_CODEC = CustomPacketPayload.codec(SetColorPayload::encode, SetColorPayload::new);
    public static final CustomPacketPayload.Type<SetColorPayload> TYPE = new CustomPacketPayload.Type(Crystalix.rl("set_color"));

    private SetColorPayload(FriendlyByteBuf buf) {
        this(buf.readVarInt());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.color);
    }

    public static void handle(SetColorPayload message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp;
            if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack wand = CrystalixWand.find((Player)player);
                if (wand.isEmpty()) {
                    return;
                }
                CSProperties properties = CSProperties.of(wand);
                CSIntegerProperty prop = (CSIntegerProperty)properties.properties().get(CSProperties.COLOR);
                if (prop == null) {
                    return;
                }
                prop.set(message.color());
                player.getInventory().setChanged();
            }
        }).exceptionally(e -> {
            ctx.disconnect((Component)CSLanguage.NETWORK_CYCLE_FAILED.text(e.getMessage()));
            return null;
        });
    }
}

