/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.data;

import dev.satherov.crystalix.core.annotations.NothingNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@NothingNull
public class CSDataProvider
implements DataProvider {
    private final boolean server;
    private final DataGenerator generator;
    private final ExistingFileHelper fileHelper;
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> lookup;
    private final RegistrySetBuilder builder;
    private final List<Provider> providers = new ArrayList<Provider>();

    private CSDataProvider(GatherDataEvent event) {
        this.generator = event.getGenerator();
        this.fileHelper = event.getExistingFileHelper();
        this.output = this.generator.getPackOutput();
        this.lookup = event.getLookupProvider();
        this.builder = new RegistrySetBuilder();
        this.server = event.includeServer();
    }

    public static CSDataProvider create(GatherDataEvent event) {
        return new CSDataProvider(event);
    }

    public void add(boolean include, Provider provider) {
        if (include) {
            this.providers.add(provider);
        }
    }

    public <T> void add(ResourceKey<? extends Registry<T>> key, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
        this.builder.add(key, bootstrap);
    }

    public void generate() {
        this.generator.addProvider(true, (DataProvider)this);
        this.generator.addProvider(this.server, output -> new DatapackBuiltinEntriesProvider(output, this.lookup, this.builder, Set.of("crystalix")));
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        for (Provider provider : this.providers) {
            list.add(provider.create(this.generator, this.output, this.fileHelper, this.lookup).run(cachedOutput));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Crystalix Data Provider";
    }

    @FunctionalInterface
    public static interface Provider {
        public DataProvider create(DataGenerator var1, PackOutput var2, ExistingFileHelper var3, CompletableFuture<HolderLookup.Provider> var4);
    }
}

