/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.client.integration.jei.source;

import es.degrassi.custommachineryars.client.integration.jei.CustomIngredientTypes;
import es.degrassi.custommachineryars.client.integration.jei.source.Source;
import es.degrassi.custommachineryars.client.render.element.SourceGuiElementWidget;
import es.degrassi.custommachineryars.guielement.SourceGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.JEIIngredientRenderer;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class SourceJEIIngredientRenderer
extends JEIIngredientRenderer<Source, SourceGuiElement> {
    public SourceJEIIngredientRenderer(SourceGuiElement element) {
        super((IGuiElement)element);
    }

    public IIngredientType<Source> getType() {
        return CustomIngredientTypes.SOURCE;
    }

    public int getWidth() {
        return ((SourceGuiElement)this.element).getWidth() - 4;
    }

    public int getHeight() {
        return ((SourceGuiElement)this.element).getHeight() - 4;
    }

    public void render(@NotNull GuiGraphics stack, @NotNull Source ingredient) {
        int width = ((SourceGuiElement)this.element).getWidth() - 4;
        int height = ((SourceGuiElement)this.element).getHeight() - 4;
        SourceGuiElementWidget.renderSource(stack.pose(), height, 0, 0, width, height);
    }

    @NotNull
    public List<Component> getTooltip(Source ingredient, @NotNull TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        String amount = Utils.format((int)ingredient.getAmount());
        if (ingredient.isPerTick()) {
            tooltips.add((Component)Component.translatable((String)"custommachineryars.jei.ingredient.source.pertick", (Object[])new Object[]{amount}));
        } else {
            tooltips.add((Component)Component.translatable((String)"custommachineryars.jei.ingredient.source", (Object[])new Object[]{amount}));
        }
        return tooltips;
    }

    public void getTooltip(ITooltipBuilder tooltip, Source ingredient, TooltipFlag tooltipFlag) {
        String amount = Utils.format((int)ingredient.getAmount());
        if (ingredient.isPerTick()) {
            tooltip.add((FormattedText)Component.translatable((String)"custommachineryars.jei.ingredient.source.pertick", (Object[])new Object[]{amount}));
        } else {
            tooltip.add((FormattedText)Component.translatable((String)"custommachineryars.jei.ingredient.source", (Object[])new Object[]{amount}));
        }
    }
}

