/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.client.render.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import es.degrassi.custommachineryars.Registration;
import es.degrassi.custommachineryars.client.ClientHandler;
import es.degrassi.custommachineryars.guielement.SourceGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public class SourceGuiElementWidget
extends TexturedGuiElementWidget<SourceGuiElement> {
    private static final int TEXTURE_SIZE = 16;

    public SourceGuiElementWidget(SourceGuiElement element, IMachineScreen screen) {
        super((AbstractTexturedGuiElement)element, screen, (Component)Component.literal((String)"Source"));
    }

    public static void renderSource(PoseStack poseStack, int sourceHeight, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        TextureAtlasSprite sprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"block/source_still")));
        SourceGuiElementWidget.drawTiledSprite(poseStack, width, height, sourceHeight, sprite);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    public void renderWidget(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(poseStack, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).ifPresent(source -> {
            double fillPercent = source.getFillPercent();
            int manaHeight = (int)(fillPercent * (double)(this.height - 4));
            SourceGuiElementWidget.renderSource(poseStack.pose(), manaHeight, this.getX() + 2, this.getY() + 2, this.width - 4, this.height - 4);
        });
        if (this.isHovered() && ((SourceGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight(poseStack, this.getX() + 2, this.getY() + 2, this.width - 4, this.height - 4);
        }
    }

    public List<Component> getTooltips() {
        if (!((SourceGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((SourceGuiElement)this.getElement()).getTooltips();
        }
        return this.getScreen().getTile().getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).map(component -> Collections.singletonList(Component.translatable((String)"custommachineryars.gui.element.source.tooltip", (Object[])new Object[]{Utils.format((int)component.getSource()), Utils.format((int)component.getCapacity())}))).orElse(Collections.emptyList());
    }

    private static void drawTiledSprite(PoseStack poseStack, int tiledWidth, int tiledHeight, int scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        Matrix4f matrix = poseStack.last().pose();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                SourceGuiElementWidget.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        float zLevel = 100.0f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + 16.0f, zLevel).setUv(uMin, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).setUv(uMax, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).setUv(uMax, vMin);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + (float)maskTop, zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

