/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class DialogueSpeaker {
    public static final MapCodec<DialogueSpeaker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("portrait").forGetter(obj -> obj.portrait), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(obj -> obj.name), (App)SoundEvent.CODEC.optionalFieldOf("talkSound", (Object)SoundEvents.UI_BUTTON_CLICK).forGetter(obj -> obj.talkSound)).apply((Applicative)instance, DialogueSpeaker::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DialogueSpeaker> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
        buf.writeResourceLocation(obj.portrait);
        ComponentSerialization.STREAM_CODEC.encode(buf, (Object)obj.name);
        SoundEvent.STREAM_CODEC.encode(buf, obj.talkSound);
    }, buf -> {
        ResourceLocation portrait = buf.readResourceLocation();
        Component name = (Component)ComponentSerialization.STREAM_CODEC.decode(buf);
        Holder talkSound = (Holder)SoundEvent.STREAM_CODEC.decode(buf);
        return new DialogueSpeaker(portrait, name, (Holder<SoundEvent>)talkSound);
    });
    public ResourceLocation portrait;
    public Component name;
    public Holder<SoundEvent> talkSound;

    public DialogueSpeaker(ResourceLocation portrait, Component name, Holder<SoundEvent> talkSound) {
        this.portrait = portrait;
        this.name = name;
        this.talkSound = talkSound;
    }
}

