/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.dialogue.styles.DialogueStyleManager;
import com.cmdpro.databank.networking.ModMessages;
import com.cmdpro.databank.networking.packet.ClickChoiceC2SPacket;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public abstract class DialogueStyle {
    public static final Codec<DialogueStyle> CODEC = DatabankRegistries.DIALOGUE_STYLE_REGISTRY.byNameCodec().dispatch(DialogueStyle::getCodec, Function.identity());

    public abstract void render(DialogueInstance var1, GuiGraphics var2, double var3, double var5);

    public abstract MapCodec<? extends DialogueStyle> getCodec();

    public static void render(ResourceLocation style, DialogueInstance instance, GuiGraphics graphics, double mouseX, double mouseY) {
        DialogueStyleManager.styles.get(style).render(instance, graphics, mouseX, mouseY);
    }

    public abstract boolean mouseClick(DialogueInstance var1, double var2, double var4, int var6);

    public boolean mouseDrag(DialogueInstance instance, double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean mouseRelease(DialogueInstance instance, double mouseX, double mouseY, int button) {
        return false;
    }

    public void changeEntry(DialogueInstance instance, String from, String to) {
    }

    public void runChoice(int index) {
        ModMessages.sendToServer(new ClickChoiceC2SPacket(index));
    }

    public void tick(DialogueInstance instance, double lastTicksPassed, double ticksPassed) {
    }
}

