/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue.actions;

import com.cmdpro.databank.dialogue.DialogueChoice;
import com.cmdpro.databank.dialogue.DialogueChoiceAction;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class CommandDialogueAction
extends DialogueChoiceAction {
    public String command;
    public static final MapCodec<CommandDialogueAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(obj -> obj.command)).apply((Applicative)instance, CommandDialogueAction::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DialogueChoiceAction> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
        if (obj instanceof CommandDialogueAction) {
            CommandDialogueAction action = (CommandDialogueAction)obj;
            buf.writeUtf(action.command);
        }
    }, buf -> {
        String command = buf.readUtf();
        return new CommandDialogueAction(command);
    });
    public static final DialogueChoiceAction.Codecs CODECS = new DialogueChoiceAction.Codecs(CODEC, STREAM_CODEC);

    @Override
    public void onClick(Player player, DialogueInstance instance, DialogueChoice choice) {
        CommandSourceStack source = player.createCommandSourceStack().withPermission(4).withSuppressedOutput();
        if (player.getServer() != null) {
            player.getServer().getCommands().performPrefixedCommand(source, this.command);
        }
    }

    public CommandDialogueAction(String command) {
        this.command = command;
    }

    @Override
    public DialogueChoiceAction.Codecs getCodecs() {
        return CODECS;
    }
}

