/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megablock;

import com.cmdpro.databank.megablock.MegablockCore;
import com.cmdpro.databank.megablock.MegablockCoreUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BasicMegablockCore
extends Block
implements MegablockCore {
    public BasicMegablockCore(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Rotation getRotation(BlockState state) {
        return Rotation.NONE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.checkPlacement(context, super.getStateForPlacement(context));
    }

    public BlockState checkPlacement(BlockPlaceContext context, BlockState state) {
        if (!MegablockCoreUtil.ableToPlace(this, this.getRotation(state), context)) {
            return null;
        }
        return state;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        MegablockCoreUtil.placeRouters(this, this.getRotation(state), level, pos);
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (state.getBlock() != newState.getBlock()) {
            MegablockCoreUtil.removeRouters(this, this.getRotation(state), level, pos);
        }
    }
}

