/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class BaseGradient<T> {
    public List<GradientPoint> points = new ArrayList<GradientPoint>();
    public float startTime;
    public float endTime;

    public BaseGradient(T start, float startTime, T end, float endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.addPoint(start, startTime, true);
        this.addPoint(end, endTime, false);
    }

    public BaseGradient(T start, T end) {
        this(start, 0.0f, end, 1.0f);
    }

    public BaseGradient<T> addPoint(T value, float time, boolean instant) {
        GradientPoint point = new GradientPoint(this, value, time, instant);
        this.points.add(point);
        this.sort();
        return this;
    }

    public BaseGradient<T> addPoint(T value, float time) {
        return this.addPoint(value, time, false);
    }

    public T getValue(float time) {
        if (time < this.startTime) {
            return this.points.getFirst().value;
        }
        if (time > this.endTime) {
            return this.points.getLast().value;
        }
        ArrayList<GradientPoint> beforeList = new ArrayList<GradientPoint>(this.points.stream().filter(i -> i.time <= time).toList());
        if (beforeList.isEmpty()) {
            return this.points.getFirst().value;
        }
        GradientPoint before = (GradientPoint)beforeList.getLast();
        List<GradientPoint> afterList = this.points.stream().filter(i -> i.time > time).toList();
        if (afterList.isEmpty()) {
            return this.points.getLast().value;
        }
        GradientPoint after = afterList.getFirst();
        if (after.instant) {
            return before.value;
        }
        float progress = (time - before.time) / (after.time - before.time);
        return this.blend(before.value, after.value, progress);
    }

    public abstract T blend(T var1, T var2, float var3);

    public BaseGradient<T> sort() {
        this.points.sort(Comparator.comparing(i -> Float.valueOf(i.time)));
        return this;
    }

    protected class GradientPoint {
        public T value;
        public float time;
        public boolean instant;

        public GradientPoint(BaseGradient this$0, T value, float time, boolean instant) {
            this.value = value;
            this.time = time;
            this.instant = instant;
        }
    }
}

