/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.misc.BaseGradient;
import com.cmdpro.databank.rendering.ColorUtil;
import java.awt.Color;

public class ColorGradient
extends BaseGradient<Color> {
    public ColorGradient(Color start, float startTime, Color end, float endTime) {
        super(start, startTime, end, endTime);
    }

    public ColorGradient(Color start, Color end) {
        super(start, end);
    }

    @Override
    public Color blend(Color from, Color to, float progress) {
        return ColorUtil.blendColors(from, to, progress);
    }

    public ColorGradient fadeAlpha(float from, float startTime, float to, float endTime) {
        Color startColor = (Color)this.getValue(startTime);
        Color endColor = (Color)this.getValue(endTime);
        this.addPoint(startColor, startTime);
        this.addPoint(endColor, endTime);
        for (BaseGradient.GradientPoint i : this.points) {
            float progress = (i.time - startTime) / (endTime - startTime);
            float alpha = from + (to - from) * progress;
            if (i.time > endTime) {
                alpha = to;
            } else if (i.time < startTime) {
                alpha = from;
            }
            i.value = new Color(((Color)i.value).getRed(), ((Color)i.value).getGreen(), ((Color)i.value).getBlue(), (int)(alpha * 255.0f * ((float)((Color)i.value).getAlpha() / 255.0f)));
        }
        this.sort();
        return this;
    }

    public ColorGradient fadeAlpha(float from, float to) {
        return this.fadeAlpha(from, this.startTime, to, this.endTime);
    }

    public ColorGradient addPoint(Color color, float time) {
        super.addPoint(color, time);
        return this;
    }

    public ColorGradient addPoint(Color value, float time, boolean instant) {
        super.addPoint(value, time, instant);
        return this;
    }

    public ColorGradient sort() {
        super.sort();
        return this;
    }

    public static ColorGradient singleColor(Color value) {
        return new ColorGradient(value, 0.0f, value, 1.0f);
    }
}

