/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import org.joml.Vector2i;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.GAME)
public class ResizeHelper {
    private static final List<ResizeListener> onResize = new ArrayList<ResizeListener>();
    private static Vector2i queuedResize;
    private static boolean hasFinishedLoad;

    public static void resize(int width, int height) {
        if (!hasFinishedLoad) {
            queuedResize = new Vector2i(width, height);
            return;
        }
        for (ResizeListener i : onResize) {
            i.resize(width, height);
        }
    }

    public static void addListener(ResizeListener listener) {
        if (!onResize.contains(listener)) {
            onResize.add(listener);
        }
    }

    public static void removeListener(ResizeListener listener) {
        onResize.remove(listener);
    }

    @SubscribeEvent
    protected static void doSetup(RenderFrameEvent.Pre event) {
        if (!hasFinishedLoad) {
            hasFinishedLoad = true;
            if (queuedResize != null) {
                int width = ResizeHelper.queuedResize.x;
                int height = ResizeHelper.queuedResize.y;
                for (ResizeListener i : onResize) {
                    i.resize(width, height);
                }
                queuedResize = null;
            }
        }
    }

    public static interface ResizeListener {
        public void resize(int var1, int var2);
    }
}

