/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.model.DatabankAnimation;
import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankPartData;
import com.cmdpro.databank.model.ModelPose;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class BaseDatabankModel<T> {
    private static final Vector3f VECTOR_CACHE = new Vector3f();
    protected ModelPose modelPose;

    public void renderPartAndChildren(T obj, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, int pColor, ModelPose.ModelPosePart part, Vec3 normalMult) {
        this.renderPartAndChildren(obj, partialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor, part, normalMult, new Quaternionf());
    }

    private void renderPartAndChildren(T obj, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, int pColor, ModelPose.ModelPosePart part, Vec3 normalMult, Quaternionf quaternionf) {
        pPoseStack.pushPose();
        if (part.part.data instanceof DatabankPartData.DatabankGroupPart) {
            pPoseStack.translate(part.pos.x / 16.0f, part.pos.y / 16.0f, part.pos.z / 16.0f);
            pPoseStack.mulPose(new Quaternionf().rotationZYX(part.rotation.z, -part.rotation.y, -part.rotation.x));
            pPoseStack.scale(part.scale.x, part.scale.y, part.scale.z);
            quaternionf.rotateZYX(part.rotation.z, -part.rotation.y, -part.rotation.x);
        }
        if (part.part.data instanceof DatabankPartData.DatabankCubePart || part.part.data instanceof DatabankPartData.DatabankMeshPart) {
            VertexConsumer consumer = pBuffer.getBuffer(this.getRenderType(obj, part));
            part.render(this.getModel(), partialTick, pPoseStack, consumer, this.getPackedLight(obj, part, pPackedLight), this.getPackedOverlay(obj, part, pPackedOverlay), this.getColor(obj, part, pColor), normalMult, this.isShadedByNormal(obj, part), new Quaternionf((Quaternionfc)quaternionf));
        }
        for (ModelPose.ModelPosePart i : part.children) {
            this.renderPartAndChildren(obj, partialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor, i, normalMult, new Quaternionf((Quaternionfc)quaternionf));
        }
        pPoseStack.popPose();
    }

    public boolean isShadedByNormal(T obj, ModelPose.ModelPosePart part) {
        Vector3f dimensions = part.part.data.getDimensions();
        float inflate = part.part.data.getInflate();
        if ((double)(dimensions.x + inflate) <= 0.001 && (double)(dimensions.x + inflate) >= -0.001) {
            return false;
        }
        if ((double)(dimensions.y + inflate) <= 0.001 && (double)(dimensions.y + inflate) >= -0.001) {
            return false;
        }
        return !((double)(dimensions.z + inflate) <= 0.001) || !((double)(dimensions.z + inflate) >= -0.001);
    }

    public int getColor(T obj, ModelPose.ModelPosePart part, int original) {
        return original;
    }

    public int getPackedLight(T obj, ModelPose.ModelPosePart part, int original) {
        return original;
    }

    public int getPackedOverlay(T obj, ModelPose.ModelPosePart part, int original) {
        return original;
    }

    public RenderType getRenderType(T obj, ModelPose.ModelPosePart part) {
        return this.getRenderType(obj);
    }

    public RenderType getRenderType(T obj) {
        return RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation());
    }

    public abstract ResourceLocation getTextureLocation();

    public abstract void setupModelPose(T var1, float var2);

    public abstract DatabankModel getModel();

    protected void animate(DatabankAnimationState state) {
        ModelPose pose = this.getModel().createModelPose();
        state.update();
        state.getAnim().animation.animationParts.forEach(i -> {
            HashMap<DatabankAnimation.AnimationKeyframe, Keyframe> keyframes = new HashMap<DatabankAnimation.AnimationKeyframe, Keyframe>();
            for (DatabankAnimation.AnimationKeyframe j : i.keyframes) {
                keyframes.put(j, j.createKeyframe());
            }
            Keyframe[] keyframeArray = keyframes.values().stream().sorted(Comparator.comparingDouble(Keyframe::timestamp)).toList().toArray(new Keyframe[0]);
            List<DatabankAnimation.AnimationKeyframe> databankKeyframes = i.keyframes.stream().sorted(Comparator.comparingDouble(animFrame -> animFrame.timestamp)).toList();
            DatabankAnimation.AnimationKeyframe current = null;
            for (DatabankAnimation.AnimationKeyframe j : databankKeyframes) {
                if (!((double)j.timestamp <= state.getProgress())) continue;
                current = j;
            }
            boolean forceNextToCurrent = false;
            if (current == null && !databankKeyframes.isEmpty()) {
                current = databankKeyframes.getFirst();
                forceNextToCurrent = true;
            }
            if (current != null) {
                int currentIndex = databankKeyframes.indexOf(current);
                int nextIndex = forceNextToCurrent ? currentIndex : (keyframes.size() > currentIndex + 1 ? currentIndex + 1 : currentIndex);
                DatabankAnimation.AnimationKeyframe next = forceNextToCurrent ? current : databankKeyframes.get(nextIndex);
                Keyframe keyframe = (Keyframe)keyframes.get(current);
                Keyframe nextKeyframe = (Keyframe)keyframes.get(next);
                AnimationChannel.Interpolation interpolation = keyframe.interpolation();
                float delta = 0.0f;
                if (currentIndex != nextIndex) {
                    delta = (float)((state.getProgress() - (double)current.timestamp) / (double)(next.timestamp - current.timestamp));
                }
                interpolation.apply(VECTOR_CACHE, delta, keyframeArray, currentIndex, nextIndex, 1.0f);
                current.targetChannel.apply(pose.stringToPart.get(i.bone), VECTOR_CACHE);
            }
        });
        this.modelPose = pose;
    }
}

