/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.model.DatabankModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;

public class DatabankModels {
    public static final int CURRENT_MODEL_VERSION = 1;
    static List<String> oldJsons = new ArrayList<String>();
    public static HashMap<ResourceLocation, DatabankModel> models = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void init() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ResourceManager resourceManager = mc.getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.registerReloadListener(DatabankModels::reload);
        }
    }

    protected static JsonObject fixJson(String name, JsonObject json) {
        int version;
        JsonObject newJson = json;
        int originalVersion = 0;
        if (json.has("version")) {
            originalVersion = json.get("version").getAsInt();
        }
        if ((version = originalVersion) == 0) {
            newJson = new JsonObject();
            JsonArray parts = json.get("parts").getAsJsonArray();
            JsonArray newParts = new JsonArray();
            for (JsonElement i : parts) {
                newParts.add((JsonElement)DatabankModels.updateV0Part(i.getAsJsonObject()));
            }
            newJson.add("parts", (JsonElement)newParts);
            newJson.add("animations", json.get("animations"));
            newJson.add("textureSize", json.get("textureSize"));
            version = 1;
        }
        if (version != originalVersion) {
            newJson.addProperty("version", (Number)version);
            oldJsons.add(name);
        }
        return newJson;
    }

    private static JsonObject updateV0Part(JsonObject part) {
        JsonObject newJson = new JsonObject();
        String partType = "databank:group";
        if (part.get("isCube").getAsBoolean()) {
            partType = "databank:cube";
        }
        if (part.get("isMesh").getAsBoolean()) {
            partType = "databank:mesh";
        }
        newJson.addProperty("type", partType);
        newJson.addProperty("name", part.get("name").getAsString());
        ArrayList<String> copyProperties = new ArrayList<String>();
        if (partType.equals("databank:group")) {
            copyProperties.add("rotation");
            copyProperties.add("offset");
            JsonArray children = new JsonArray();
            for (Object i : part.get("children").getAsJsonArray()) {
                children.add((JsonElement)DatabankModels.updateV0Part(i.getAsJsonObject()));
            }
            newJson.add("children", (JsonElement)children);
        }
        if (partType.equals("databank:cube")) {
            copyProperties.add("rotation");
            copyProperties.add("offset");
            copyProperties.add("texOffset");
            copyProperties.add("mirror");
            copyProperties.add("origin");
            copyProperties.add("dimensions");
            copyProperties.add("inflate");
        }
        if (partType.equals("databank:mesh")) {
            copyProperties.add("rotation");
            copyProperties.add("offset");
            copyProperties.add("mirror");
            JsonArray newFaces = new JsonArray();
            JsonObject newVertices = new JsonObject();
            for (JsonElement face : part.get("faces").getAsJsonArray()) {
                JsonArray newFace = new JsonArray();
                for (JsonElement vertex : face.getAsJsonArray()) {
                    JsonObject vertObj = vertex.getAsJsonObject();
                    String vertexId = String.valueOf(newVertices.size());
                    JsonObject newVertex = new JsonObject();
                    newVertex.add("x", vertObj.get("x"));
                    newVertex.add("y", vertObj.get("y"));
                    newVertex.add("z", vertObj.get("z"));
                    newVertex.add("weights", (JsonElement)new JsonObject());
                    newVertices.add(vertexId, (JsonElement)newVertex);
                    JsonObject newVertRef = new JsonObject();
                    newVertRef.addProperty("id", vertexId);
                    newVertRef.add("u", vertObj.get("u"));
                    newVertRef.add("v", vertObj.get("v"));
                    newFace.add((JsonElement)newVertRef);
                }
                newFaces.add((JsonElement)newFace);
            }
            newJson.add("faces", (JsonElement)newFaces);
            newJson.add("vertices", (JsonElement)newVertices);
        }
        HashMap<String, Object> copyPropertyDefaults = new HashMap<String, Object>();
        JsonArray texOffsetDefault = new JsonArray();
        texOffsetDefault.add((Number)0);
        texOffsetDefault.add((Number)0);
        copyPropertyDefaults.put("texOffset", texOffsetDefault);
        JsonArray originDefault = new JsonArray();
        originDefault.add((Number)0);
        originDefault.add((Number)0);
        originDefault.add((Number)0);
        copyPropertyDefaults.put("origin", originDefault);
        JsonArray dimensionsDefault = new JsonArray();
        dimensionsDefault.add((Number)1);
        dimensionsDefault.add((Number)1);
        dimensionsDefault.add((Number)1);
        copyPropertyDefaults.put("dimensions", dimensionsDefault);
        copyPropertyDefaults.put("mirror", new JsonPrimitive(Boolean.valueOf(false)));
        copyPropertyDefaults.put("inflate", new JsonPrimitive((Number)0));
        for (String i : copyProperties) {
            JsonElement property = part.has(i) ? part.get(i) : ((JsonElement)copyPropertyDefaults.get(i)).deepCopy();
            newJson.add(i, property);
        }
        return newJson;
    }

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.listResources("databank/models", name -> name.toString().endsWith(".json")), backgroundExecutor).thenApply(resources -> {
            HashMap<ResourceLocation, CompletableFuture<DatabankModel>> tasks = new HashMap<ResourceLocation, CompletableFuture<DatabankModel>>();
            for (ResourceLocation i : resources.keySet()) {
                tasks.put(i, CompletableFuture.supplyAsync(() -> {
                    JsonObject json;
                    try {
                        Resource resource = resourceManager.getResourceOrThrow(i);
                        InputStream stream = resource.open();
                        json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (String)IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset()), JsonObject.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    json = DatabankModels.fixJson(i.toString(), json);
                    return (DatabankModel)DatabankModel.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
                }));
            }
            return tasks;
        })).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAccept(tasks -> {
            HashMap<ResourceLocation, DatabankModel> models = new HashMap<ResourceLocation, DatabankModel>();
            for (Map.Entry entry : tasks.entrySet()) {
                String path = ((ResourceLocation)entry.getKey()).getPath().replaceFirst("databank/models/", "");
                path = path.substring(0, path.length() - 5);
                models.put(((ResourceLocation)entry.getKey()).withPath(path), (DatabankModel)((CompletableFuture)entry.getValue()).join());
            }
            models = models;
            for (String string : oldJsons) {
                Databank.LOGGER.info("Databank Model \"" + string + "\" needs to be updated! If you are a player, you may ignore this as it has been automatically fixed temporarily. If you are a developer, please run the python script in the databank github to update your models.");
            }
            oldJsons.clear();
            Databank.LOGGER.info("[DATABANK] Loaded Databank Models");
        });
    }
}

