/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.DatabankExtraCodecs;
import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankPartDefinition;
import com.cmdpro.databank.model.ModelPose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public abstract class DatabankPartData {
    public static final Codec<DatabankPartData> CODEC = DatabankRegistries.MODEL_PART_TYPE_REGISTRY.byNameCodec().dispatch(DatabankPartData::getCodec, Function.identity());
    public DatabankPartDefinition part;
    public String name;

    public abstract MapCodec<? extends DatabankPartData> getCodec();

    public Vector3f getOffset() {
        return new Vector3f();
    }

    public Vector3f getRotation() {
        return new Vector3f();
    }

    public Vector3f getDimensions() {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public List<DatabankPartDefinition> getChildren() {
        return null;
    }

    public float getInflate() {
        return 0.0f;
    }

    public PartPose createPartPose() {
        Vector3f offset = this.getOffset();
        Vector3f rotation = this.getRotation();
        return PartPose.offsetAndRotation((float)offset.x, (float)offset.y, (float)offset.z, (float)rotation.x, (float)rotation.y, (float)rotation.z);
    }

    public Matrix4f getMatrixWithParents(boolean ignoreGroups) {
        ArrayList<DatabankPartDefinition> parts = new ArrayList<DatabankPartDefinition>();
        DatabankPartDefinition current = this.part;
        while (current != null) {
            parts.addFirst(current);
            current = current.parent;
        }
        if (parts.isEmpty()) {
            return new Matrix4f();
        }
        Quaternionf rotation = new Quaternionf();
        Vector3f offset = new Vector3f();
        for (DatabankPartDefinition i : parts) {
            if (ignoreGroups && i.data instanceof DatabankGroupPart) continue;
            offset.add((Vector3fc)new Vector3f((Vector3fc)i.data.getOffset()).rotate((Quaternionfc)rotation));
            rotation.rotateXYZ(i.data.getRotation().x, i.data.getRotation().y, i.data.getRotation().z);
        }
        Matrix4f mat4 = new Matrix4f();
        mat4.translate((Vector3fc)offset);
        mat4.rotate((Quaternionfc)rotation);
        return mat4;
    }

    public void render(ModelPose.ModelPosePart posePart, DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult, boolean isShadedByNormal, Quaternionf quaternionf) {
    }

    public void renderFaces(List<Face> faces, ModelPose.ModelPosePart posePart, DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult, boolean isShadedByNormal, Quaternionf quaternionf) {
        if (faces != null) {
            for (Face i : faces) {
                if (i.vertices.size() != 3 && i.vertices.size() != 4) continue;
                Vector3f normal = i.normal.toVector3f().rotate((Quaternionfc)quaternionf);
                if (!isShadedByNormal) {
                    normal = new Vec3(0.0, 1.0, 0.0).multiply(normalMult).toVector3f();
                }
                for (DrawVertex j : i.vertices) {
                    float x = (float)j.pos.x() / 16.0f;
                    float y = (float)j.pos.y() / 16.0f;
                    float z = (float)j.pos.z() / 16.0f;
                    pConsumer.addVertex(pPoseStack.last(), x, y, z);
                    pConsumer.setColor(pColor);
                    pConsumer.setUv(j.u / (float)model.textureSize.x, j.v / (float)model.textureSize.y);
                    pConsumer.setOverlay(pPackedOverlay);
                    pConsumer.setLight(pPackedLight);
                    pConsumer.setNormal(normal.x, normal.y, normal.z);
                }
                if (i.vertices.size() != 3) continue;
                DrawVertex j = i.vertices.getLast();
                float x = (float)j.pos.x() / 16.0f;
                float y = (float)j.pos.y() / 16.0f;
                float z = (float)j.pos.z() / 16.0f;
                pConsumer.addVertex(pPoseStack.last(), x, y, z);
                pConsumer.setColor(pColor);
                pConsumer.setUv(j.u / (float)model.textureSize.x, j.v / (float)model.textureSize.y);
                pConsumer.setOverlay(pPackedOverlay);
                pConsumer.setLight(pPackedLight);
                pConsumer.setNormal(normal.x, normal.y, normal.z);
            }
        }
    }

    public static class DatabankGroupPart
    extends DatabankPartData {
        public static final MapCodec<DatabankGroupPart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(data -> data.name), (App)ExtraCodecs.VECTOR3F.fieldOf("rotation").forGetter(data -> data.rotation), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(data -> data.offset), (App)DatabankPartDefinition.CODEC.listOf().fieldOf("children").forGetter(data -> data.children)).apply((Applicative)instance, DatabankGroupPart::new));
        public Vector3f rotation;
        public Vector3f offset;
        public List<DatabankPartDefinition> children;

        public DatabankGroupPart(String name, Vector3f rotation, Vector3f offset, List<DatabankPartDefinition> children) {
            this.name = name;
            this.rotation = rotation;
            this.offset = offset;
            this.children = children;
        }

        @Override
        public MapCodec<? extends DatabankPartData> getCodec() {
            return CODEC;
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Override
        public List<DatabankPartDefinition> getChildren() {
            return this.children;
        }
    }

    public static class Face {
        public List<DrawVertex> vertices;
        public Vec3 normal;

        public Face(List<DrawVertex> vertices, Vec3 normal) {
            this.vertices = vertices;
            this.normal = normal;
        }
    }

    public static class DrawVertex {
        public Vec3 pos;
        public float u;
        public float v;

        public DrawVertex(Vec3 pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }

    public static class Vertex {
        public static final Codec<Vertex> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(vertice -> vertice.pos.x), (App)Codec.DOUBLE.fieldOf("y").forGetter(vertice -> vertice.pos.y), (App)Codec.DOUBLE.fieldOf("z").forGetter(vertice -> vertice.pos.z), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).fieldOf("weights").forGetter(vertice -> vertice.weights)).apply((Applicative)instance, (x, y, z, weights) -> new Vertex(new Vec3(x.doubleValue(), y.doubleValue(), z.doubleValue()), (Map<String, Float>)weights)));
        public Vec3 pos;
        public Map<String, Float> weights;

        public Vertex(Vec3 pos, Map<String, Float> weights) {
            this.pos = pos;
            this.weights = weights;
        }

        public Vertex(Vec3 pos) {
            this(pos, Map.of());
        }
    }

    public static class VertexRef {
        public static final Codec<VertexRef> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(vertex -> vertex.vertexId), (App)Codec.FLOAT.fieldOf("u").forGetter(vertex -> Float.valueOf(vertex.u)), (App)Codec.FLOAT.fieldOf("v").forGetter(vertex -> Float.valueOf(vertex.v))).apply((Applicative)instance, VertexRef::new));
        public String vertexId;
        public float u;
        public float v;

        public VertexRef(String vertexId, float u, float v) {
            this.vertexId = vertexId;
            this.u = u;
            this.v = v;
        }

        public Vertex getVertex(Map<String, Vertex> vertices) {
            return vertices.get(this.vertexId);
        }
    }

    public static class DatabankMeshPart
    extends DatabankPartData {
        public static final MapCodec<DatabankMeshPart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(data -> data.name), (App)ExtraCodecs.VECTOR3F.fieldOf("rotation").forGetter(data -> data.rotation), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(data -> data.offset), (App)Codec.unboundedMap((Codec)Codec.STRING, Vertex.CODEC).fieldOf("vertices").forGetter(part -> part.vertices), (App)VertexRef.CODEC.listOf().listOf().fieldOf("faces").forGetter(part -> part.faces)).apply((Applicative)instance, DatabankMeshPart::new));
        public Vector3f rotation;
        public Vector3f offset;
        public Map<String, Vertex> vertices;
        public List<List<VertexRef>> faces;

        public DatabankMeshPart(String name, Vector3f rotation, Vector3f offset, Map<String, Vertex> vertices, List<List<VertexRef>> faces) {
            this.name = name;
            this.rotation = rotation;
            this.offset = offset;
            this.vertices = vertices;
            this.faces = faces;
        }

        @Override
        public MapCodec<? extends DatabankPartData> getCodec() {
            return CODEC;
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Override
        public void render(ModelPose.ModelPosePart posePart, DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult, boolean isShadedByNormal, Quaternionf quaternionf) {
            pPoseStack.translate(posePart.pos.x / 16.0f, posePart.pos.y / 16.0f, posePart.pos.z / 16.0f);
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateXYZ(this.rotation.x, -this.rotation.y, this.rotation.z);
            quaternionf.rotateXYZ(this.rotation.x, this.rotation.y, this.rotation.z);
            List<List<VertexRef>> faces2 = this.faces;
            ArrayList<Face> faces = new ArrayList<Face>();
            HashMap<String, Vertex> vertices = new HashMap<String, Vertex>();
            for (Map.Entry<String, Vertex> entry : this.vertices.entrySet()) {
                Vector3f pos = entry.getValue().pos.toVector3f();
                Matrix4f mat4 = new Matrix4f();
                Object target = new Vector3f();
                Matrix4f armatureMatrixInverse = new Matrix4f((Matrix4fc)posePart.parent.parent.getMatrixWithParents(true)).invert();
                Matrix4f bindMatrix = new Matrix4f((Matrix4fc)armatureMatrixInverse);
                bindMatrix.mul((Matrix4fc)this.getMatrixWithParents(true));
                Matrix4f bindMatrixInverse = new Matrix4f((Matrix4fc)bindMatrix).invert();
                pos.mulPosition((Matrix4fc)bindMatrix);
                Map<ModelPose.ModelPosePart, Float> affectingBones = entry.getValue().weights.entrySet().stream().map(j -> Map.entry(posePart.pose.allBones.get(j.getKey()), (Float)j.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (affectingBones.size() > 4) {
                    List<Float> highest = affectingBones.values().stream().sorted().toList().subList(0, 4);
                    for (Map.Entry<ModelPose.ModelPosePart, Float> j2 : affectingBones.entrySet()) {
                        if (!(j2.getValue().floatValue() < highest.getLast().floatValue())) continue;
                        affectingBones.remove(j2.getKey());
                    }
                }
                ArrayList<ModelPose.ModelPosePart> bones = new ArrayList<ModelPose.ModelPosePart>(affectingBones.keySet());
                ArrayList<Float> weights = new ArrayList<Float>(affectingBones.values());
                while (weights.size() < 4) {
                    weights.add(Float.valueOf(0.0f));
                }
                Vector4f weightsVector = new Vector4f(((Float)weights.get(0)).floatValue(), ((Float)weights.get(1)).floatValue(), ((Float)weights.get(2)).floatValue(), ((Float)weights.get(3)).floatValue());
                float scale = 1.0f / weightsVector.length();
                if (scale != Float.POSITIVE_INFINITY) {
                    weightsVector.mul(scale);
                    weights.set(0, Float.valueOf(weightsVector.x));
                    weights.set(1, Float.valueOf(weightsVector.y));
                    weights.set(2, Float.valueOf(weightsVector.z));
                    weights.set(3, Float.valueOf(weightsVector.w));
                    for (int j3 = 0; j3 < 4; ++j3) {
                        float weight = ((Float)weights.get(j3)).floatValue();
                        if (weight == 0.0f || affectingBones.size() <= j3) continue;
                        ModelPose.ModelPosePart bone = (ModelPose.ModelPosePart)bones.get(j3);
                        mat4 = new Matrix4f((Matrix4fc)armatureMatrixInverse).mul((Matrix4fc)bone.getMatrixWithParents(true));
                        mat4.mul((Matrix4fc)new Matrix4f((Matrix4fc)bone.part.data.getMatrixWithParents(true)).invert());
                        target.add((Vector3fc)new Vector3f((Vector3fc)pos).mulPosition((Matrix4fc)mat4).mul(weight));
                    }
                } else {
                    target = new Vector3f((Vector3fc)pos);
                }
                target.mulPosition((Matrix4fc)bindMatrixInverse);
                Vertex vert = new Vertex(new Vec3((double)((Vector3f)target).x, (double)((Vector3f)target).y, (double)((Vector3f)target).z), entry.getValue().weights);
                vertices.put(entry.getKey(), vert);
            }
            for (List list : faces2) {
                if (list.size() != 3 && list.size() != 4) continue;
                ArrayList<Vertex> refVerts = new ArrayList<Vertex>();
                ArrayList<DrawVertex> verts = new ArrayList<DrawVertex>();
                for (VertexRef j4 : list) {
                    Vertex refVert = j4.getVertex(vertices);
                    refVerts.add(refVert);
                    Vector3f pos = matrix4f.transformPosition(refVert.pos.toVector3f());
                    verts.add(new DrawVertex(new Vec3((double)pos.x, (double)pos.y, (double)pos.z), j4.u, j4.v));
                }
                Vec3 vecA = ((Vertex)refVerts.get((int)1)).pos.subtract(((Vertex)refVerts.get((int)0)).pos);
                Vec3 vecB = ((Vertex)refVerts.get((int)2)).pos.subtract(((Vertex)refVerts.get((int)0)).pos);
                Vector3f normal = vecA.cross(vecB).toVector3f().normalize();
                faces.add(new Face(verts, new Vec3((double)normal.x, (double)normal.y, (double)normal.z)));
            }
            this.renderFaces(faces, posePart, model, partialTick, pPoseStack, pConsumer, pPackedLight, pPackedOverlay, pColor, normalMult, isShadedByNormal, quaternionf);
        }
    }

    public static class DatabankCubePart
    extends DatabankPartData {
        public static final MapCodec<DatabankCubePart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(data -> data.name), (App)ExtraCodecs.VECTOR3F.fieldOf("rotation").forGetter(data -> data.rotation), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(data -> data.offset), (App)DatabankExtraCodecs.VECTOR2I.fieldOf("texOffset").forGetter(data -> data.texOffset), (App)Codec.BOOL.fieldOf("mirror").forGetter(data -> data.mirror), (App)ExtraCodecs.VECTOR3F.fieldOf("origin").forGetter(data -> data.origin), (App)ExtraCodecs.VECTOR3F.fieldOf("dimensions").forGetter(data -> data.dimensions), (App)Codec.FLOAT.fieldOf("inflate").forGetter(data -> Float.valueOf(data.inflate))).apply((Applicative)instance, DatabankCubePart::new));
        public Vector3f rotation;
        public Vector3f offset;
        public Vector2i texOffset;
        public boolean mirror;
        public Vector3f origin;
        public Vector3f dimensions;
        public float inflate;

        public DatabankCubePart(String name, Vector3f rotation, Vector3f offset, Vector2i texOffset, boolean mirror, Vector3f origin, Vector3f dimensions, float inflate) {
            this.name = name;
            this.rotation = rotation;
            this.offset = offset;
            this.texOffset = texOffset;
            this.mirror = mirror;
            this.origin = origin;
            this.dimensions = dimensions;
            this.inflate = inflate;
        }

        @Override
        public MapCodec<? extends DatabankPartData> getCodec() {
            return CODEC;
        }

        public CubeListBuilder createCubeListBuilder() {
            return CubeListBuilder.create().texOffs(this.texOffset.x, this.texOffset.y).mirror(this.mirror).addBox(this.origin.x, this.origin.y, this.origin.z, this.dimensions.x, this.dimensions.y, this.dimensions.z, new CubeDeformation(this.inflate));
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public float getInflate() {
            return this.inflate;
        }

        @Override
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Override
        public Vector3f getDimensions() {
            return this.dimensions;
        }

        @Override
        public void render(ModelPose.ModelPosePart posePart, DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult, boolean isShadedByNormal, Quaternionf quaternionf) {
            pPoseStack.pushPose();
            Vec3 origin = new Vec3((double)this.origin.x, (double)this.origin.y, (double)this.origin.z);
            Vec3 x0y0z0 = new Vec3(0.0, 0.0, 0.0).add((double)(-this.inflate), (double)(-this.inflate), (double)(-this.inflate)).add(origin);
            Vec3 x1y0z0 = new Vec3((double)this.dimensions.x, 0.0, 0.0).add((double)this.inflate, (double)(-this.inflate), (double)(-this.inflate)).add(origin);
            Vec3 x1y1z0 = new Vec3((double)this.dimensions.x, (double)this.dimensions.y, 0.0).add((double)this.inflate, (double)this.inflate, (double)(-this.inflate)).add(origin);
            Vec3 x0y1z0 = new Vec3(0.0, (double)this.dimensions.y, 0.0).add((double)(-this.inflate), (double)this.inflate, (double)(-this.inflate)).add(origin);
            Vec3 x0y0z1 = new Vec3(0.0, 0.0, (double)this.dimensions.z).add((double)(-this.inflate), (double)(-this.inflate), (double)this.inflate).add(origin);
            Vec3 x1y0z1 = new Vec3((double)this.dimensions.x, 0.0, (double)this.dimensions.z).add((double)this.inflate, (double)(-this.inflate), (double)this.inflate).add(origin);
            Vec3 x1y1z1 = new Vec3((double)this.dimensions.x, (double)this.dimensions.y, (double)this.dimensions.z).add((double)this.inflate, (double)this.inflate, (double)this.inflate).add(origin);
            Vec3 x0y1z1 = new Vec3(0.0, (double)this.dimensions.y, (double)this.dimensions.z).add((double)(-this.inflate), (double)this.inflate, (double)this.inflate).add(origin);
            float uMin = (float)this.texOffset.x + this.dimensions.z;
            float vMin = this.texOffset.y;
            float uMax = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x;
            float vMax = (float)this.texOffset.y + this.dimensions.z;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> up = new ArrayList<DrawVertex>();
            up.add(new DrawVertex(x1y1z1, uMin, vMin));
            up.add(new DrawVertex(x0y1z1, uMax, vMin));
            up.add(new DrawVertex(x0y1z0, uMax, vMax));
            up.add(new DrawVertex(x1y1z0, uMin, vMax));
            uMin = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x;
            vMin = this.texOffset.y;
            uMax = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x + this.dimensions.x;
            vMax = (float)this.texOffset.y + this.dimensions.z;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> down = new ArrayList<DrawVertex>();
            down.add(new DrawVertex(x1y0z1, uMin, vMin));
            down.add(new DrawVertex(x0y0z1, uMax, vMin));
            down.add(new DrawVertex(x0y0z0, uMax, vMax));
            down.add(new DrawVertex(x1y0z0, uMin, vMax));
            uMin = (float)this.texOffset.x + this.dimensions.z;
            vMin = (float)this.texOffset.y + this.dimensions.z;
            uMax = this.texOffset.x;
            vMax = (float)this.texOffset.y + this.dimensions.z + this.dimensions.y;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> east = new ArrayList<DrawVertex>();
            east.add(new DrawVertex(x1y1z1, uMax, vMin));
            east.add(new DrawVertex(x1y1z0, uMin, vMin));
            east.add(new DrawVertex(x1y0z0, uMin, vMax));
            east.add(new DrawVertex(x1y0z1, uMax, vMax));
            uMin = (float)this.texOffset.x + this.dimensions.z;
            vMin = (float)this.texOffset.y + this.dimensions.z;
            uMax = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x;
            vMax = (float)this.texOffset.y + this.dimensions.z + this.dimensions.y;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> north = new ArrayList<DrawVertex>();
            north.add(new DrawVertex(x1y1z0, uMin, vMin));
            north.add(new DrawVertex(x0y1z0, uMax, vMin));
            north.add(new DrawVertex(x0y0z0, uMax, vMax));
            north.add(new DrawVertex(x1y0z0, uMin, vMax));
            uMin = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x + this.dimensions.z;
            vMin = (float)this.texOffset.y + this.dimensions.z;
            uMax = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x;
            vMax = (float)this.texOffset.y + this.dimensions.z + this.dimensions.y;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> west = new ArrayList<DrawVertex>();
            west.add(new DrawVertex(x0y1z1, uMin, vMin));
            west.add(new DrawVertex(x0y1z0, uMax, vMin));
            west.add(new DrawVertex(x0y0z0, uMax, vMax));
            west.add(new DrawVertex(x0y0z1, uMin, vMax));
            uMin = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x + this.dimensions.z;
            vMin = (float)this.texOffset.y + this.dimensions.z;
            uMax = (float)this.texOffset.x + this.dimensions.z + this.dimensions.x + this.dimensions.z + this.dimensions.x;
            vMax = (float)this.texOffset.y + this.dimensions.z + this.dimensions.y;
            if (this.mirror) {
                float uMinBackup = uMin;
                uMin = uMax;
                uMax = uMinBackup;
            }
            ArrayList<DrawVertex> south = new ArrayList<DrawVertex>();
            south.add(new DrawVertex(x1y1z1, uMax, vMin));
            south.add(new DrawVertex(x0y1z1, uMin, vMin));
            south.add(new DrawVertex(x0y0z1, uMin, vMax));
            south.add(new DrawVertex(x1y0z1, uMax, vMax));
            boolean[] facesVisible = new boolean[]{true, true, true, true, true, true};
            Vec3[] normals = new Vec3[]{new Vec3(0.0, 1.0 * normalMult.y, 0.0), new Vec3(0.0, -1.0 * normalMult.y, 0.0), new Vec3(1.0 * normalMult.x, 0.0, 0.0), new Vec3(0.0, 0.0, -1.0 * normalMult.z), new Vec3(-1.0 * normalMult.x, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0 * normalMult.z)};
            if ((double)(this.dimensions.x + this.inflate) <= 0.001 && (double)(this.dimensions.x + this.inflate) >= -0.001) {
                facesVisible[2] = false;
            }
            if ((double)(this.dimensions.y + this.inflate) <= 0.001 && (double)(this.dimensions.y + this.inflate) >= -0.001) {
                facesVisible[1] = false;
            }
            if ((double)(this.dimensions.z + this.inflate) <= 0.001 && (double)(this.dimensions.z + this.inflate) >= -0.001) {
                facesVisible[5] = false;
            }
            ArrayList<Face> faces = new ArrayList<Face>();
            if (facesVisible[0]) {
                faces.add(new Face(up, normals[0]));
            }
            if (facesVisible[1]) {
                faces.add(new Face(down, normals[1]));
            }
            if (facesVisible[2]) {
                faces.add(new Face(east, normals[2]));
            }
            if (facesVisible[3]) {
                faces.add(new Face(north, normals[3]));
            }
            if (facesVisible[4]) {
                faces.add(new Face(west, normals[4]));
            }
            if (facesVisible[5]) {
                faces.add(new Face(south, normals[5]));
            }
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateZYX(this.rotation.z, this.rotation.y, this.rotation.x);
            quaternionf.rotateZYX(this.rotation.z, -this.rotation.y, this.rotation.x);
            for (Face i : faces) {
                for (DrawVertex j : i.vertices) {
                    Vector3f pos = j.pos.toVector3f();
                    matrix4f.transformPosition(pos);
                    pos.add((Vector3fc)new Vector3f(posePart.pos.x, posePart.pos.y, posePart.pos.z));
                    j.pos = new Vec3((double)pos.x, (double)pos.y, (double)pos.z);
                }
            }
            pPoseStack.popPose();
            this.renderFaces(faces, posePart, model, partialTick, pPoseStack, pConsumer, pPackedLight, pPackedOverlay, pColor, normalMult, isShadedByNormal, quaternionf);
        }
    }

    public static class DatabankBonePart
    extends DatabankPartData {
        public static final MapCodec<DatabankBonePart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(data -> data.name), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(data -> data.offset), (App)ExtraCodecs.VECTOR3F.fieldOf("rotation").forGetter(data -> data.rotation), (App)ExtraCodecs.VECTOR3F.fieldOf("dimensions").forGetter(data -> data.dimensions), (App)DatabankPartDefinition.CODEC.listOf().fieldOf("children").forGetter(data -> data.children)).apply((Applicative)instance, DatabankBonePart::new));
        public Vector3f offset;
        public List<DatabankPartDefinition> children;
        public Vector3f rotation;
        public Vector3f dimensions;

        public DatabankBonePart(String name, Vector3f offset, Vector3f rotation, Vector3f dimensions, List<DatabankPartDefinition> children) {
            this.name = name;
            this.offset = offset;
            this.rotation = rotation;
            this.dimensions = dimensions;
            this.children = children;
        }

        @Override
        public MapCodec<? extends DatabankPartData> getCodec() {
            return CODEC;
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Override
        public Vector3f getDimensions() {
            return this.dimensions;
        }

        @Override
        public List<DatabankPartDefinition> getChildren() {
            return this.children;
        }
    }

    public static class DatabankArmaturePart
    extends DatabankPartData {
        public static final MapCodec<DatabankArmaturePart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(data -> data.name), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(data -> data.offset), (App)DatabankPartDefinition.CODEC.listOf().fieldOf("children").forGetter(data -> data.children)).apply((Applicative)instance, DatabankArmaturePart::new));
        public Vector3f offset;
        public List<DatabankPartDefinition> children;

        public DatabankArmaturePart(String name, Vector3f offset, List<DatabankPartDefinition> children) {
            this.name = name;
            this.offset = offset;
            this.children = children;
        }

        @Override
        public MapCodec<? extends DatabankPartData> getCodec() {
            return CODEC;
        }

        @Override
        public Vector3f getOffset() {
            return this.offset;
        }

        @Override
        public List<DatabankPartDefinition> getChildren() {
            return this.children;
        }
    }
}

