/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.multiblock.predicates.serializers;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.multiblock.MultiblockPredicateSerializer;
import com.cmdpro.databank.multiblock.predicates.BlockstateMultiblockPredicate;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockstateMultiblockPredicateSerializer
extends MultiblockPredicateSerializer<BlockstateMultiblockPredicate> {
    public static final BlockstateMultiblockPredicateSerializer INSTANCE = new BlockstateMultiblockPredicateSerializer();
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockstateMultiblockPredicate> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> pBuffer.writeUtf(BlockStateParser.serialize((BlockState)pValue.self)), pBuffer -> {
        BlockState state = BlockstateMultiblockPredicateSerializer.getBlockStateFromBuf((FriendlyByteBuf)pBuffer);
        return new BlockstateMultiblockPredicate(state);
    });
    public static final MapCodec<BlockstateMultiblockPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("state").forGetter(page -> BlockStateParser.serialize((BlockState)page.self))).apply((Applicative)instance, state -> {
        try {
            return new BlockstateMultiblockPredicate(BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)state, (boolean)false).blockState());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }));

    public static BlockState getBlockStateFromBuf(FriendlyByteBuf buf) {
        try {
            return BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)buf.readUtf(), (boolean)false).blockState();
        }
        catch (Exception e) {
            Databank.LOGGER.error("[DATABANK ERROR] " + e.getMessage());
            return Blocks.AIR.defaultBlockState();
        }
    }

    @Override
    public MapCodec<BlockstateMultiblockPredicate> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, BlockstateMultiblockPredicate> getStreamCodec() {
        return STREAM_CODEC;
    }
}

